/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.query.DialectJDBCStreamQueryBuilder;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDBCStreamQueryBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCStreamQueryBuilder.class);

    public static PreparedStatement build(DatabaseType databaseType, Connection connection, String sql, int batchSize) throws SQLException {
        Optional dialectBuilder = DatabaseTypedSPILoader.findService(DialectJDBCStreamQueryBuilder.class, (DatabaseType)databaseType);
        if (dialectBuilder.isPresent()) {
            return ((DialectJDBCStreamQueryBuilder)dialectBuilder.get()).build(connection, sql, batchSize);
        }
        log.warn("not support {} streaming query now, pay attention to memory usage", (Object)databaseType.getType());
        return connection.prepareStatement(sql, 1003, 1007);
    }

    @Generated
    private JDBCStreamQueryBuilder() {
    }
}

