/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.node.config.processor;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJob;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobRegistry;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.config.processor.JobConfigurationChangedProcessor;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineDistributedBarrier;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.JobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.OneOffJobBootstrap;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobConfigurationChangedProcessEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobConfigurationChangedProcessEngine.class);

    public <T extends PipelineJobConfiguration> void process(DataChangedEvent.Type eventType, JobConfiguration jobConfig, JobConfigurationChangedProcessor<T> processor) {
        String jobId = jobConfig.getJobName();
        if (jobConfig.isDisabled()) {
            Collection<Integer> shardingItems = PipelineJobRegistry.getShardingItems(jobId);
            PipelineJobRegistry.stop(jobId);
            this.disableJob(jobId, shardingItems);
        }
        switch (eventType) {
            case ADDED: 
            case UPDATED: {
                if (jobConfig.isDisabled()) break;
                if (PipelineJobRegistry.isExisting(jobId)) {
                    log.info("{} added to executing jobs failed since it already exists", (Object)jobId);
                    break;
                }
                Object pipelineJobConfig = PipelineJobIdUtils.parseJobType(jobConfig.getJobName()).getOption().getYamlJobConfigurationSwapper().swapToObject(jobConfig.getJobParameter());
                this.executeJob(jobConfig, (T)pipelineJobConfig, processor);
                break;
            }
            case DELETED: {
                PipelineJobRegistry.stop(jobId);
                processor.clean(jobConfig);
                break;
            }
        }
    }

    private void disableJob(String jobId, Collection<Integer> shardingItems) {
        PipelineDistributedBarrier distributedBarrier = PipelineDistributedBarrier.getInstance(PipelineJobIdUtils.parseContextKey(jobId));
        for (Integer each : shardingItems) {
            distributedBarrier.persistEphemeralChildrenNode(PipelineMetaDataNode.getJobBarrierDisablePath(jobId), each);
        }
    }

    private <T extends PipelineJobConfiguration> void executeJob(JobConfiguration jobConfig, T pipelineJobConfig, JobConfigurationChangedProcessor<T> processor) {
        PipelineJob job = processor.createJob(pipelineJobConfig);
        String jobId = jobConfig.getJobName();
        PipelineJobRegistry.add(jobId, job);
        OneOffJobBootstrap oneOffJobBootstrap = new OneOffJobBootstrap(PipelineAPIFactory.getRegistryCenter(PipelineJobIdUtils.parseContextKey(jobId)), (ElasticJob)job, jobConfig);
        job.getJobRunnerManager().setJobBootstrap((JobBootstrap)oneOffJobBootstrap);
        oneOffJobBootstrap.execute();
    }
}

