/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.checker.ShardingTableRuleStatementChecker;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingTableRuleStatementConverter;
import org.apache.shardingsphere.sharding.distsql.handler.update.UnusedAlgorithmFinder;
import org.apache.shardingsphere.sharding.distsql.statement.AlterShardingTableRuleStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

@DistSQLExecutorCurrentRuleRequired(value=ShardingRule.class)
public final class AlterShardingTableRuleExecutor
implements DatabaseRuleAlterExecutor<AlterShardingTableRuleStatement, ShardingRule, ShardingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShardingRule rule;

    public void checkBeforeUpdate(AlterShardingTableRuleStatement sqlStatement) {
        ShardingTableRuleStatementChecker.checkAlteration(this.database, sqlStatement.getRules(), this.rule.getConfiguration());
        this.checkUniqueActualDataNodes(sqlStatement);
    }

    private void checkUniqueActualDataNodes(AlterShardingTableRuleStatement sqlStatement) {
        this.rule.getShardingRuleChecker().checkToBeAddedDataNodes(ShardingTableRuleStatementConverter.convertDataNodes(sqlStatement.getRules()), true);
    }

    public ShardingRuleConfiguration buildToBeAlteredRuleConfiguration(AlterShardingTableRuleStatement sqlStatement) {
        return ShardingTableRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(ShardingRuleConfiguration toBeAlteredRuleConfig) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        Collection toBeAlteredShardingTableNames = toBeAlteredRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet());
        for (ShardingAutoTableRuleConfiguration each2 : this.rule.getConfiguration().getAutoTables()) {
            if (!toBeAlteredShardingTableNames.contains(each2.getLogicTable())) continue;
            result.getAutoTables().add(each2);
        }
        Collection toBeAlteredAutoTableNames = toBeAlteredRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet());
        for (ShardingTableRuleConfiguration each3 : this.rule.getConfiguration().getTables()) {
            if (!toBeAlteredAutoTableNames.contains(each3.getLogicTable())) continue;
            result.getTables().add(each3);
        }
        UnusedAlgorithmFinder.findUnusedShardingAlgorithm(this.rule.getConfiguration()).forEach(each -> result.getShardingAlgorithms().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getShardingAlgorithms().get(each)));
        UnusedAlgorithmFinder.findUnusedKeyGenerator(this.rule.getConfiguration()).forEach(each -> result.getKeyGenerators().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getKeyGenerators().get(each)));
        UnusedAlgorithmFinder.findUnusedAuditor(this.rule.getConfiguration()).forEach(each -> result.getAuditors().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getAuditors().get(each)));
        return result;
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<AlterShardingTableRuleStatement> getType() {
        return AlterShardingTableRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

