/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.driver.jdbc.adapter.executor.ForceExecuteTemplate;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;

public final class StatementManager
implements ExecutorJDBCStatementManager,
AutoCloseable {
    private final Map<CacheKey, Statement> cachedStatements = new ConcurrentHashMap<CacheKey, Statement>();
    private final ForceExecuteTemplate<Statement> forceExecuteTemplate = new ForceExecuteTemplate();

    public Statement createStorageResource(Connection connection, ConnectionMode connectionMode, StatementOption option, DatabaseType databaseType) throws SQLException {
        return this.createStatement(connection, option);
    }

    public Statement createStorageResource(ExecutionUnit executionUnit, Connection connection, int connectionOffset, ConnectionMode connectionMode, StatementOption option, DatabaseType databaseType) throws SQLException {
        CacheKey cacheKey = new CacheKey(executionUnit, connectionMode, connectionOffset);
        Statement result = this.cachedStatements.get(cacheKey);
        if (null == result || result.getConnection().isClosed() || result.isClosed()) {
            Optional.ofNullable(result).ifPresent(optional -> this.cachedStatements.remove(cacheKey));
            result = this.prepareStatement(executionUnit, connection, option);
            this.cachedStatements.put(cacheKey, result);
        }
        return result;
    }

    private Statement createStatement(Connection connection, StatementOption option) throws SQLException {
        Statement result;
        try {
            result = connection.createStatement(option.getResultSetType(), option.getResultSetConcurrency(), option.getResultSetHoldability());
        }
        catch (SQLFeatureNotSupportedException ignore) {
            result = connection.createStatement();
        }
        return result;
    }

    private PreparedStatement prepareStatement(ExecutionUnit executionUnit, Connection connection, StatementOption option) throws SQLException {
        String sql = executionUnit.getSqlUnit().getSql();
        PreparedStatement result = option.isReturnGeneratedKeys() ? (null == option.getColumns() || 0 == option.getColumns().length ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql, option.getColumns())) : this.prepareStatement(connection, sql, option.getResultSetType(), option.getResultSetConcurrency(), option.getResultSetHoldability());
        return result;
    }

    private PreparedStatement prepareStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement result;
        try {
            result = connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLFeatureNotSupportedException ignore) {
            result = connection.prepareStatement(sql);
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.forceExecuteTemplate.execute(this.cachedStatements.values(), Statement::close);
        }
        finally {
            this.cachedStatements.clear();
        }
    }

    private static final class CacheKey {
        private final ExecutionUnit executionUnit;
        private final ConnectionMode connectionMode;
        private final int connectionOffset;

        @Generated
        public CacheKey(ExecutionUnit executionUnit, ConnectionMode connectionMode, int connectionOffset) {
            this.executionUnit = executionUnit;
            this.connectionMode = connectionMode;
            this.connectionOffset = connectionOffset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.connectionOffset != other.connectionOffset) {
                return false;
            }
            ExecutionUnit this$executionUnit = this.executionUnit;
            ExecutionUnit other$executionUnit = other.executionUnit;
            if (this$executionUnit == null ? other$executionUnit != null : !this$executionUnit.equals(other$executionUnit)) {
                return false;
            }
            ConnectionMode this$connectionMode = this.connectionMode;
            ConnectionMode other$connectionMode = other.connectionMode;
            return !(this$connectionMode == null ? other$connectionMode != null : !this$connectionMode.equals(other$connectionMode));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.connectionOffset;
            ExecutionUnit $executionUnit = this.executionUnit;
            result = result * 59 + ($executionUnit == null ? 43 : $executionUnit.hashCode());
            ConnectionMode $connectionMode = this.connectionMode;
            result = result * 59 + ($connectionMode == null ? 43 : $connectionMode.hashCode());
            return result;
        }
    }
}

