/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.prepare;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.exception.FirebirdProtocolException;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.FirebirdBinaryColumnType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql.FirebirdSQLInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.prepare.FirebirdPrepareStatementReturnPacket;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;

public final class FirebirdReturnColumnPacket
extends FirebirdPacket {
    private final Collection<FirebirdSQLInfoPacketType> requestedItems;
    private final int index;
    private final ShardingSphereTable table;
    private final ShardingSphereColumn column;
    private final String tableAlias;
    private final String columnAlias;
    private final String owner;
    private final Integer columnLength;
    private final boolean blobColumn;
    private final Integer blobSubType;

    @Override
    protected void write(FirebirdPacketPayload payload) {
        FirebirdBinaryColumnType columnType = this.blobColumn ? FirebirdBinaryColumnType.BLOB : FirebirdBinaryColumnType.valueOfJDBCType(this.column.getDataType());
        block13: for (FirebirdSQLInfoPacketType requestedItem : this.requestedItems) {
            switch (requestedItem) {
                case SQLDA_SEQ: {
                    FirebirdPrepareStatementReturnPacket.writeInt(FirebirdSQLInfoPacketType.SQLDA_SEQ, this.index, payload);
                    continue block13;
                }
                case TYPE: {
                    int type = columnType.getValue() + 1;
                    FirebirdPrepareStatementReturnPacket.writeInt(FirebirdSQLInfoPacketType.TYPE, type, payload);
                    continue block13;
                }
                case SUB_TYPE: {
                    int subType = columnType.getSubtype();
                    if (columnType == FirebirdBinaryColumnType.BLOB && null != this.blobSubType) {
                        subType = this.blobSubType;
                    }
                    FirebirdPrepareStatementReturnPacket.writeInt(FirebirdSQLInfoPacketType.SUB_TYPE, subType, payload);
                    continue block13;
                }
                case SCALE: {
                    FirebirdPrepareStatementReturnPacket.writeInt(FirebirdSQLInfoPacketType.SCALE, 0, payload);
                    continue block13;
                }
                case LENGTH: {
                    if (columnType == FirebirdBinaryColumnType.VARYING || columnType == FirebirdBinaryColumnType.LEGACY_VARYING || columnType == FirebirdBinaryColumnType.TEXT || columnType == FirebirdBinaryColumnType.LEGACY_TEXT) {
                        FirebirdPrepareStatementReturnPacket.writeInt(FirebirdSQLInfoPacketType.LENGTH, this.columnLength, payload);
                        continue block13;
                    }
                    int length = columnType.getLength();
                    FirebirdPrepareStatementReturnPacket.writeInt(FirebirdSQLInfoPacketType.LENGTH, length, payload);
                    continue block13;
                }
                case FIELD: {
                    FirebirdPrepareStatementReturnPacket.writeString(FirebirdSQLInfoPacketType.FIELD, this.column.getName(), payload);
                    continue block13;
                }
                case ALIAS: {
                    FirebirdPrepareStatementReturnPacket.writeString(FirebirdSQLInfoPacketType.ALIAS, this.columnAlias, payload);
                    continue block13;
                }
                case RELATION: {
                    FirebirdPrepareStatementReturnPacket.writeString(FirebirdSQLInfoPacketType.RELATION, this.table.getName(), payload);
                    continue block13;
                }
                case RELATION_ALIAS: {
                    FirebirdPrepareStatementReturnPacket.writeString(FirebirdSQLInfoPacketType.RELATION_ALIAS, this.tableAlias, payload);
                    continue block13;
                }
                case OWNER: {
                    FirebirdPrepareStatementReturnPacket.writeString(FirebirdSQLInfoPacketType.OWNER, this.owner, payload);
                    continue block13;
                }
                case DESCRIBE_END: {
                    FirebirdPrepareStatementReturnPacket.writeCode(FirebirdSQLInfoPacketType.DESCRIBE_END, payload);
                    continue block13;
                }
            }
            throw new FirebirdProtocolException("Unknown statement info request type %d", requestedItem);
        }
    }

    @Generated
    public FirebirdReturnColumnPacket(Collection<FirebirdSQLInfoPacketType> requestedItems, int index, ShardingSphereTable table, ShardingSphereColumn column, String tableAlias, String columnAlias, String owner, Integer columnLength, boolean blobColumn, Integer blobSubType) {
        this.requestedItems = requestedItems;
        this.index = index;
        this.table = table;
        this.column = column;
        this.tableAlias = tableAlias;
        this.columnAlias = columnAlias;
        this.owner = owner;
        this.columnLength = columnLength;
        this.blobColumn = blobColumn;
        this.blobSubType = blobSubType;
    }
}

