/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.FirebirdBinaryColumnType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBlobBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdDateBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdDoubleBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdFloatBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdInt16BinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdInt1BinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdInt2BinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdInt4BinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdInt8BinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdNullBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdStringBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdTimeBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdTimestampBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdTimestampTZBinaryProtocolValue;

public final class FirebirdBinaryProtocolValueFactory {
    private static final Map<BinaryColumnType, FirebirdBinaryProtocolValue> BINARY_PROTOCOL_VALUES = new HashMap<BinaryColumnType, FirebirdBinaryProtocolValue>();

    private static void setStringBinaryProtocolValue() {
        FirebirdStringBinaryProtocolValue binaryProtocolValue = new FirebirdStringBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.VARYING, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.TEXT, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.LEGACY_VARYING, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.LEGACY_TEXT, binaryProtocolValue);
    }

    private static void setBlobBinaryProtocolValue() {
        FirebirdBlobBinaryProtocolValue binaryProtocolValue = new FirebirdBlobBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.BLOB, binaryProtocolValue);
    }

    private static void setInt16BinaryProtocolValue() {
        FirebirdInt16BinaryProtocolValue binaryProtocolValue = new FirebirdInt16BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.INT128, binaryProtocolValue);
    }

    private static void setInt8BinaryProtocolValue() {
        FirebirdInt8BinaryProtocolValue binaryProtocolValue = new FirebirdInt8BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.INT64, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.NUMERIC, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.DECIMAL, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.DEC34, binaryProtocolValue);
    }

    private static void setInt4BinaryProtocolValue() {
        FirebirdInt4BinaryProtocolValue binaryProtocolValue = new FirebirdInt4BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.LONG, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.DEC16, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.QUAD, binaryProtocolValue);
    }

    private static void setInt2BinaryProtocolValue() {
        FirebirdInt2BinaryProtocolValue binaryProtocolValue = new FirebirdInt2BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.SHORT, binaryProtocolValue);
    }

    private static void setInt1BinaryProtocolValue() {
        FirebirdInt1BinaryProtocolValue binaryProtocolValue = new FirebirdInt1BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.BOOLEAN, binaryProtocolValue);
    }

    private static void setDoubleBinaryProtocolValue() {
        FirebirdDoubleBinaryProtocolValue binaryProtocolValue = new FirebirdDoubleBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.DOUBLE, binaryProtocolValue);
    }

    private static void setFloatBinaryProtocolValue() {
        FirebirdFloatBinaryProtocolValue binaryProtocolValue = new FirebirdFloatBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.FLOAT, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.D_FLOAT, binaryProtocolValue);
    }

    private static void setDateBinaryProtocolValue() {
        FirebirdDateBinaryProtocolValue binaryProtocolValue = new FirebirdDateBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.DATE, binaryProtocolValue);
    }

    private static void setTimeBinaryProtocolValue() {
        FirebirdTimeBinaryProtocolValue binaryProtocolValue = new FirebirdTimeBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.TIME, binaryProtocolValue);
    }

    private static void setTimestampBinaryProtocolValue() {
        FirebirdTimestampBinaryProtocolValue binaryProtocolValue = new FirebirdTimestampBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.TIMESTAMP, binaryProtocolValue);
    }

    private static void setTimestampTZBinaryProtocolValue() {
        FirebirdTimestampTZBinaryProtocolValue binaryProtocolValue = new FirebirdTimestampTZBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.TIMESTAMP_TZ, binaryProtocolValue);
    }

    private static void setNullBinaryProtocolValue() {
        FirebirdNullBinaryProtocolValue binaryProtocolValue = new FirebirdNullBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(FirebirdBinaryColumnType.NULL, binaryProtocolValue);
    }

    public static FirebirdBinaryProtocolValue getBinaryProtocolValue(BinaryColumnType binaryColumnType) {
        Preconditions.checkArgument((boolean)BINARY_PROTOCOL_VALUES.containsKey(binaryColumnType), (String)"Cannot find Firebird type '%s' in column type when process binary protocol value", (Object)binaryColumnType);
        return BINARY_PROTOCOL_VALUES.get(binaryColumnType);
    }

    @Generated
    private FirebirdBinaryProtocolValueFactory() {
    }

    static {
        FirebirdBinaryProtocolValueFactory.setStringBinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setInt16BinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setInt8BinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setInt4BinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setInt2BinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setInt1BinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setDoubleBinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setFloatBinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setDateBinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setTimeBinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setTimestampBinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setTimestampTZBinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setNullBinaryProtocolValue();
        FirebirdBinaryProtocolValueFactory.setBlobBinaryProtocolValue();
    }
}

