/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.database;

import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdArchType;
import org.apache.shardingsphere.database.protocol.firebird.exception.FirebirdProtocolException;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.FirebirdInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.common.FirebirdCommonInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.database.FirebirdDatabaseInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdDatabaseInfoReturnPacket
extends FirebirdPacket {
    private static final int SQL_DIALECT = 3;
    private static final String BUILD_TYPE = "V";
    private static final int MAJOR_VERSION = 5;
    private static final int MINOR_VERSION = 0;
    private static final int REV_NO = 0;
    private static final int BUILD_NO = 0;
    private static final String SERVER_NAME = String.format("Firebird %d.%d (ShardingSphere-Proxy)", 5, 0);
    private static final String FB_VERSION = String.format("%s-%s%d.%d.%d.%d %s", FirebirdArchType.ARCHITECTURE.getIdentifier(), "V", 5, 0, 0, 0, SERVER_NAME);
    private final List<FirebirdInfoPacketType> infoItems;

    @Override
    protected void write(FirebirdPacketPayload payload) {
        for (FirebirdInfoPacketType type : this.infoItems) {
            if (type.isCommon()) {
                FirebirdCommonInfoPacketType.parseCommonInfo(payload, (FirebirdCommonInfoPacketType)type);
                continue;
            }
            this.parseDatabaseInfo(payload, (FirebirdDatabaseInfoPacketType)type);
        }
    }

    private void parseDatabaseInfo(FirebirdPacketPayload data, FirebirdDatabaseInfoPacketType type) {
        switch (type) {
            case DB_SQL_DIALECT: {
                data.writeInt1(FirebirdDatabaseInfoPacketType.DB_SQL_DIALECT.getCode());
                data.writeInt2LE(1);
                data.writeInt1(3);
                break;
            }
            case ODS_VERSION: {
                data.writeInt1(FirebirdDatabaseInfoPacketType.ODS_VERSION.getCode());
                data.writeInt2LE(4);
                data.writeInt4LE(5);
                break;
            }
            case ODS_MINOR_VERSION: {
                data.writeInt1(FirebirdDatabaseInfoPacketType.ODS_MINOR_VERSION.getCode());
                data.writeInt2LE(4);
                data.writeInt4LE(0);
                break;
            }
            case FIREBIRD_VERSION: {
                data.writeInt1(FirebirdDatabaseInfoPacketType.FIREBIRD_VERSION.getCode());
                data.writeInt2LE(FB_VERSION.length() + 2);
                data.writeInt1(1);
                data.writeInt1(FB_VERSION.length());
                data.writeBytes(FB_VERSION.getBytes(StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw new FirebirdProtocolException("Unknown database information request type %d", type.getCode());
            }
        }
    }

    @Generated
    public FirebirdDatabaseInfoReturnPacket(List<FirebirdInfoPacketType> infoItems) {
        this.infoItems = infoItems;
    }

    @Generated
    public List<FirebirdInfoPacketType> getInfoItems() {
        return this.infoItems;
    }
}

