/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.constant.protocol;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.database.protocol.firebird.constant.protocol.FirebirdProtocolVersion;

public final class FirebirdConnectionProtocolVersion {
    private static final FirebirdConnectionProtocolVersion INSTANCE = new FirebirdConnectionProtocolVersion();
    private final Map<Integer, FirebirdProtocolVersion> protocolVersionCache = new ConcurrentHashMap<Integer, FirebirdProtocolVersion>();

    public static FirebirdConnectionProtocolVersion getInstance() {
        return INSTANCE;
    }

    public void setProtocolVersion(int connectionId, FirebirdProtocolVersion protocolVersion) {
        this.protocolVersionCache.put(connectionId, protocolVersion);
    }

    public FirebirdProtocolVersion getProtocolVersion(int connectionId) {
        return this.protocolVersionCache.get(connectionId);
    }

    public void unsetProtocolVersion(int connectionId) {
        this.protocolVersionCache.remove(connectionId);
    }
}

