/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.constant.buffer.type;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdValueFormat;
import org.apache.shardingsphere.database.protocol.firebird.constant.buffer.FirebirdParameterBuffer;
import org.apache.shardingsphere.database.protocol.firebird.constant.buffer.FirebirdParameterBufferType;

public enum FirebirdTransactionParameterBufferType implements FirebirdParameterBufferType
{
    CONSISTENCY(1),
    CONCURRENCY(2),
    SHARED(3),
    PROTECTED(4),
    EXCLUSIVE(5),
    WAIT(6),
    NOWAIT(7),
    READ(8),
    WRITE(9),
    LOCK_READ(10),
    LOCK_WRITE(11),
    VERB_TIME(12),
    COMMIT_TIME(13),
    IGNORE_LIMBO(14),
    READ_COMMITTED(15),
    AUTOCOMMIT(16),
    REC_VERSION(17),
    NO_REC_VERSION(18),
    RESTART_REQUESTS(19),
    NO_AUTO_UNDO(20),
    LOCK_TIMEOUT(21, FirebirdValueFormat.INT),
    READ_CONSISTENCY(22),
    AT_SNAPSHOT_NUMBER(23);

    private static final Map<Integer, FirebirdTransactionParameterBufferType> FIREBIRD_TPB_TYPE_CACHE;
    private final int code;
    private final FirebirdValueFormat format;

    private FirebirdTransactionParameterBufferType(int code) {
        this(code, FirebirdValueFormat.BOOLEAN);
    }

    public static FirebirdTransactionParameterBufferType valueOf(int code) {
        FirebirdTransactionParameterBufferType result = FIREBIRD_TPB_TYPE_CACHE.get(code);
        Preconditions.checkNotNull((Object)result, (String)"Cannot find code '%d' in tpb type", (int)code);
        return result;
    }

    public static boolean isTraditionalType(int version) {
        return true;
    }

    public static FirebirdParameterBuffer createBuffer() {
        return new FirebirdParameterBuffer(FirebirdTransactionParameterBufferType::valueOf, FirebirdTransactionParameterBufferType::isTraditionalType);
    }

    @Generated
    private FirebirdTransactionParameterBufferType(int code, FirebirdValueFormat format) {
        this.code = code;
        this.format = format;
    }

    @Override
    @Generated
    public int getCode() {
        return this.code;
    }

    @Override
    @Generated
    public FirebirdValueFormat getFormat() {
        return this.format;
    }

    static {
        FIREBIRD_TPB_TYPE_CACHE = new HashMap<Integer, FirebirdTransactionParameterBufferType>();
        for (FirebirdTransactionParameterBufferType each : FirebirdTransactionParameterBufferType.values()) {
            FIREBIRD_TPB_TYPE_CACHE.put(each.code, each);
        }
    }
}

