/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.task;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.core.task.runner.PipelineTasksRunner;

public final class CDCTasksRunner
implements PipelineTasksRunner {
    private final TransmissionJobItemContext jobItemContext;
    private final Collection<PipelineTask> inventoryTasks;
    private final Collection<PipelineTask> incrementalTasks;

    public CDCTasksRunner(TransmissionJobItemContext jobItemContext) {
        this.jobItemContext = jobItemContext;
        this.inventoryTasks = jobItemContext.getInventoryTasks();
        this.incrementalTasks = jobItemContext.getIncrementalTasks();
    }

    public void start() {
    }

    public void stop() {
        this.jobItemContext.setStopping(true);
        for (PipelineTask each : this.inventoryTasks) {
            each.stop();
        }
        for (PipelineTask each : this.incrementalTasks) {
            each.stop();
        }
    }

    @Generated
    public TransmissionJobItemContext getJobItemContext() {
        return this.jobItemContext;
    }
}

