/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.tcl.xa.type;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionManager;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnector;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.xa.jta.exception.XATransactionNestedBeginException;

public final class XABeginProxyBackendHandler
implements ProxyBackendHandler {
    private final ShardingSphereMetaData metaData;
    private final ConnectionSession connectionSession;
    private final DatabaseProxyConnector databaseProxyConnector;

    @Override
    public ResponseHeader execute() throws SQLException {
        ShardingSpherePreconditions.checkState((!this.connectionSession.getTransactionStatus().isInTransaction() ? 1 : 0) != 0, XATransactionNestedBeginException::new);
        ResponseHeader result = this.databaseProxyConnector.execute();
        TransactionRule transactionRule = (TransactionRule)this.metaData.getGlobalRuleMetaData().getSingleRule(TransactionRule.class);
        ShardingSphereTransactionManagerEngine engine = transactionRule.getResource();
        this.connectionSession.getConnectionContext().getTransactionContext().beginTransaction(transactionRule.getDefaultType().name(), (TransactionManager)engine.getTransactionManager(transactionRule.getDefaultType()));
        return result;
    }

    @Generated
    public XABeginProxyBackendHandler(ShardingSphereMetaData metaData, ConnectionSession connectionSession, DatabaseProxyConnector databaseProxyConnector) {
        this.metaData = metaData;
        this.connectionSession = connectionSession;
        this.databaseProxyConnector = databaseProxyConnector;
    }
}

