/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable.label;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.distsql.statement.type.ral.updatable.LabelComputeNodeStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.persist.facade.ClusterPersistServiceFacade;

@DistSQLExecutorClusterModeRequired
public final class LabelComputeNodeExecutor
implements DistSQLUpdateExecutor<LabelComputeNodeStatement> {
    public void executeUpdate(LabelComputeNodeStatement sqlStatement, ContextManager contextManager) {
        String instanceId = sqlStatement.getInstanceId();
        Optional computeNodeInstance = contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry().find(instanceId);
        if (computeNodeInstance.isPresent()) {
            LinkedHashSet labels = new LinkedHashSet(sqlStatement.getLabels());
            if (!sqlStatement.isOverwrite()) {
                labels.addAll(((ComputeNodeInstance)computeNodeInstance.get()).getLabels());
            }
            ClusterPersistServiceFacade clusterPersistServiceFacade = (ClusterPersistServiceFacade)contextManager.getPersistServiceFacade().getModeFacade();
            clusterPersistServiceFacade.getComputeNodeService().persistLabels(instanceId, new LinkedList(labels));
        }
    }

    public Class<LabelComputeNodeStatement> getType() {
        return LabelComputeNodeStatement.class;
    }
}

