/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.config.yaml.swapper;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceGeneratedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.datasource.pool.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.proxy.backend.config.ProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.ProxyGlobalConfiguration;
import org.apache.shardingsphere.proxy.backend.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDataSourceConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyServerConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.swapper.YamlProxyDataSourceConfigurationSwapper;

public final class YamlProxyConfigurationSwapper {
    private final YamlProxyDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlProxyDataSourceConfigurationSwapper();
    private final YamlRuleConfigurationSwapperEngine ruleConfigSwapperEngine = new YamlRuleConfigurationSwapperEngine();

    public ProxyConfiguration swap(YamlProxyConfiguration yamlConfig) {
        boolean isInstanceConnectionEnabled = (Boolean)yamlConfig.getServerConfiguration().getProps().getOrDefault((Object)TemporaryConfigurationPropertyKey.INSTANCE_CONNECTION_ENABLED.getKey(), Boolean.FALSE);
        Map<String, DatabaseConfiguration> databaseConfigs = this.swapDatabaseConfigurations(yamlConfig.getDatabaseConfigurations(), isInstanceConnectionEnabled);
        ProxyGlobalConfiguration globalConfig = this.swapGlobalConfiguration(yamlConfig.getServerConfiguration());
        return new ProxyConfiguration(databaseConfigs, globalConfig);
    }

    private ProxyGlobalConfiguration swapGlobalConfiguration(YamlProxyServerConfiguration yamlConfig) {
        Map<String, DataSource> dataSources = this.swapDataSources(yamlConfig.getDataSources());
        Collection ruleConfigs = this.ruleConfigSwapperEngine.swapToRuleConfigurations(yamlConfig.getRules());
        return new ProxyGlobalConfiguration(dataSources, ruleConfigs, null == yamlConfig.getProps() ? new Properties() : yamlConfig.getProps(), null == yamlConfig.getLabels() ? Collections.emptyList() : yamlConfig.getLabels());
    }

    private Map<String, DataSource> swapDataSources(Map<String, YamlProxyDataSourceConfiguration> yamlDataSourceConfigs) {
        Map<String, DataSourceConfiguration> dataSourceConfigs = this.swapDataSourceConfigurations(yamlDataSourceConfigs);
        Map propsMap = dataSourceConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePoolPropertiesCreator.create((DataSourceConfiguration)((DataSourceConfiguration)entry.getValue())), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return DataSourcePoolCreator.create((Map)propsMap, (boolean)true);
    }

    private Map<String, DatabaseConfiguration> swapDatabaseConfigurations(Map<String, YamlProxyDatabaseConfiguration> databaseConfigs, boolean isInstanceConnectionEnabled) {
        LinkedHashMap<String, DatabaseConfiguration> result = new LinkedHashMap<String, DatabaseConfiguration>(databaseConfigs.size(), 1.0f);
        for (Map.Entry<String, YamlProxyDatabaseConfiguration> entry : databaseConfigs.entrySet()) {
            Map<String, DataSourceConfiguration> databaseDataSourceConfigs = this.swapDataSourceConfigurations(entry.getValue().getDataSources());
            Collection databaseRuleConfigs = this.ruleConfigSwapperEngine.swapToRuleConfigurations(entry.getValue().getRules());
            result.put(entry.getKey(), (DatabaseConfiguration)new DataSourceGeneratedDatabaseConfiguration(databaseDataSourceConfigs, databaseRuleConfigs, isInstanceConnectionEnabled));
        }
        return result;
    }

    private Map<String, DataSourceConfiguration> swapDataSourceConfigurations(Map<String, YamlProxyDataSourceConfiguration> yamlConfigs) {
        LinkedHashMap<String, DataSourceConfiguration> result = new LinkedHashMap<String, DataSourceConfiguration>(yamlConfigs.size(), 1.0f);
        for (Map.Entry<String, YamlProxyDataSourceConfiguration> entry : yamlConfigs.entrySet()) {
            result.put(entry.getKey(), this.dataSourceConfigSwapper.swap(entry.getValue()));
        }
        return result;
    }
}

