/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl;

import com.google.common.base.Strings;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.column.DialectColumnOption;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.extractor.ProjectionIdentifierExtractEngine;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParenthesesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ColumnProjection
implements Projection {
    private final IdentifierValue owner;
    private final IdentifierValue name;
    private final IdentifierValue alias;
    private final DatabaseType databaseType;
    private final ParenthesesSegment leftParentheses;
    private final ParenthesesSegment rightParentheses;
    private final ColumnSegmentBoundInfo columnBoundInfo;
    private String columnLabel;
    private String columnName;

    public ColumnProjection(String owner, String name, String alias, DatabaseType databaseType) {
        this(null == owner ? null : new IdentifierValue(owner, QuoteCharacter.NONE), new IdentifierValue(name, QuoteCharacter.NONE), null == alias ? null : new IdentifierValue(alias, QuoteCharacter.NONE), databaseType, null, null, null);
    }

    public ColumnProjection(IdentifierValue owner, IdentifierValue name, IdentifierValue alias, DatabaseType databaseType) {
        this(owner, name, alias, databaseType, null, null, null);
    }

    public ColumnProjection(IdentifierValue owner, IdentifierValue name, IdentifierValue alias, DatabaseType databaseType, ParenthesesSegment leftParentheses, ParenthesesSegment rightParentheses) {
        this(owner, name, alias, databaseType, leftParentheses, rightParentheses, null);
    }

    public ColumnProjection(IdentifierValue owner, IdentifierValue name, IdentifierValue alias, DatabaseType databaseType, ParenthesesSegment leftParentheses, ParenthesesSegment rightParentheses, ColumnSegmentBoundInfo columnBoundInfo, boolean initColumnNameAndLabel) {
        this.owner = owner;
        this.name = name;
        this.alias = alias;
        this.databaseType = databaseType;
        this.leftParentheses = leftParentheses;
        this.rightParentheses = rightParentheses;
        this.columnBoundInfo = columnBoundInfo;
        if (initColumnNameAndLabel) {
            this.columnName = this.createColumnName(name, databaseType);
            this.columnLabel = this.createColumnLabel(name, databaseType);
        }
    }

    public Optional<IdentifierValue> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public IdentifierValue getOriginalTable() {
        if (null == this.columnBoundInfo || null == this.columnBoundInfo.getOriginalTable() || Strings.isNullOrEmpty((String)this.columnBoundInfo.getOriginalTable().getValue())) {
            return null == this.owner ? new IdentifierValue("") : this.owner;
        }
        return this.columnBoundInfo.getOriginalTable();
    }

    public IdentifierValue getOriginalColumn() {
        return null == this.columnBoundInfo || null == this.columnBoundInfo.getOriginalColumn() || Strings.isNullOrEmpty((String)this.columnBoundInfo.getOriginalColumn().getValue()) ? this.name : this.columnBoundInfo.getOriginalColumn();
    }

    public Optional<ParenthesesSegment> getLeftParentheses() {
        return Optional.ofNullable(this.leftParentheses);
    }

    public Optional<ParenthesesSegment> getRightParentheses() {
        return Optional.ofNullable(this.rightParentheses);
    }

    @Override
    public String getColumnName() {
        return null == this.columnName ? this.createColumnName(this.name, this.databaseType) : this.columnName;
    }

    @Override
    public String getColumnLabel() {
        return null == this.columnLabel ? this.createColumnLabel(this.name, this.databaseType) : this.columnLabel;
    }

    private String createColumnName(IdentifierValue name, DatabaseType databaseType) {
        ProjectionIdentifierExtractEngine extractEngine = new ProjectionIdentifierExtractEngine(databaseType);
        DialectColumnOption columnOption = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getColumnOption();
        return columnOption.isColumnNameEqualsLabelInColumnProjection() ? this.getColumnLabel() : extractEngine.getIdentifierValue(name);
    }

    private String createColumnLabel(IdentifierValue name, DatabaseType databaseType) {
        ProjectionIdentifierExtractEngine extractEngine = new ProjectionIdentifierExtractEngine(databaseType);
        return this.getAlias().map(extractEngine::getIdentifierValue).orElseGet(() -> extractEngine.getIdentifierValue(name));
    }

    @Override
    public String getExpression() {
        return null == this.owner ? this.name.getValue() : this.owner.getValue() + "." + this.name.getValue();
    }

    @Override
    public Optional<IdentifierValue> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    @Generated
    public ColumnProjection(IdentifierValue owner, IdentifierValue name, IdentifierValue alias, DatabaseType databaseType, ParenthesesSegment leftParentheses, ParenthesesSegment rightParentheses, ColumnSegmentBoundInfo columnBoundInfo) {
        this.owner = owner;
        this.name = name;
        this.alias = alias;
        this.databaseType = databaseType;
        this.leftParentheses = leftParentheses;
        this.rightParentheses = rightParentheses;
        this.columnBoundInfo = columnBoundInfo;
    }

    @Generated
    public IdentifierValue getName() {
        return this.name;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public ColumnSegmentBoundInfo getColumnBoundInfo() {
        return this.columnBoundInfo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnProjection)) {
            return false;
        }
        ColumnProjection other = (ColumnProjection)o;
        Optional<IdentifierValue> this$owner = this.getOwner();
        Optional<IdentifierValue> other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        IdentifierValue this$name = this.getName();
        IdentifierValue other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<IdentifierValue> this$alias = this.getAlias();
        Optional<IdentifierValue> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
            return false;
        }
        DatabaseType this$databaseType = this.getDatabaseType();
        DatabaseType other$databaseType = other.getDatabaseType();
        if (this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType)) {
            return false;
        }
        Optional<ParenthesesSegment> this$leftParentheses = this.getLeftParentheses();
        Optional<ParenthesesSegment> other$leftParentheses = other.getLeftParentheses();
        if (this$leftParentheses == null ? other$leftParentheses != null : !((Object)this$leftParentheses).equals(other$leftParentheses)) {
            return false;
        }
        Optional<ParenthesesSegment> this$rightParentheses = this.getRightParentheses();
        Optional<ParenthesesSegment> other$rightParentheses = other.getRightParentheses();
        if (this$rightParentheses == null ? other$rightParentheses != null : !((Object)this$rightParentheses).equals(other$rightParentheses)) {
            return false;
        }
        String this$columnLabel = this.getColumnLabel();
        String other$columnLabel = other.getColumnLabel();
        if (this$columnLabel == null ? other$columnLabel != null : !this$columnLabel.equals(other$columnLabel)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<IdentifierValue> $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        IdentifierValue $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<IdentifierValue> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
        DatabaseType $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
        Optional<ParenthesesSegment> $leftParentheses = this.getLeftParentheses();
        result = result * 59 + ($leftParentheses == null ? 43 : ((Object)$leftParentheses).hashCode());
        Optional<ParenthesesSegment> $rightParentheses = this.getRightParentheses();
        result = result * 59 + ($rightParentheses == null ? 43 : ((Object)$rightParentheses).hashCode());
        String $columnLabel = this.getColumnLabel();
        result = result * 59 + ($columnLabel == null ? 43 : $columnLabel.hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ColumnProjection(owner=" + this.getOwner() + ", name=" + this.getName() + ", alias=" + this.getAlias() + ", databaseType=" + this.getDatabaseType() + ", leftParentheses=" + this.getLeftParentheses() + ", rightParentheses=" + this.getRightParentheses() + ", columnBoundInfo=" + this.getColumnBoundInfo() + ", columnLabel=" + this.getColumnLabel() + ", columnName=" + this.getColumnName() + ")";
    }
}

