/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.prepare.driver;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.DriverExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.prepare.AbstractExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.SQLExecutionUnitBuilder;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.JDBCDriverType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class DriverExecutionPrepareEngine<T extends DriverExecutionUnit<?>, C>
extends AbstractExecutionPrepareEngine<T> {
    private static final Map<JDBCDriverType, SQLExecutionUnitBuilder> TYPE_TO_BUILDER_MAP = new ConcurrentHashMap<JDBCDriverType, SQLExecutionUnitBuilder>(8, 1.0f);
    private final JDBCDriverType type;
    private final DatabaseConnectionManager<C> databaseConnectionManager;
    private final ExecutorStatementManager<C, ?, ?> statementManager;
    private final StorageResourceOption option;
    private final SQLExecutionUnitBuilder sqlExecutionUnitBuilder;
    private final ShardingSphereMetaData metaData;

    public DriverExecutionPrepareEngine(JDBCDriverType type, int maxConnectionsSizePerQuery, DatabaseConnectionManager<C> databaseConnectionManager, ExecutorStatementManager<C, ?, ?> statementManager, StorageResourceOption option, Collection<ShardingSphereRule> rules, ShardingSphereMetaData metaData) {
        super(maxConnectionsSizePerQuery, rules);
        this.type = type;
        this.databaseConnectionManager = databaseConnectionManager;
        this.statementManager = statementManager;
        this.option = option;
        this.sqlExecutionUnitBuilder = this.getCachedSQLExecutionUnitBuilder(type);
        this.metaData = metaData;
    }

    private SQLExecutionUnitBuilder getCachedSQLExecutionUnitBuilder(JDBCDriverType type) {
        SQLExecutionUnitBuilder result = TYPE_TO_BUILDER_MAP.get((Object)type);
        if (null == result) {
            result = TYPE_TO_BUILDER_MAP.computeIfAbsent(type, key -> (SQLExecutionUnitBuilder)TypedSPILoader.getService(SQLExecutionUnitBuilder.class, (Object)key));
        }
        return result;
    }

    @Override
    protected List<ExecutionGroup<T>> group(String databaseName, String dataSourceName, int connectionOffset, List<List<ExecutionUnit>> executionUnitGroups, ConnectionMode connectionMode) throws SQLException {
        LinkedList<ExecutionGroup<T>> result = new LinkedList<ExecutionGroup<T>>();
        List<C> connections = this.databaseConnectionManager.getConnections(databaseName, dataSourceName, connectionOffset, executionUnitGroups.size(), connectionMode);
        int count = 0;
        for (List<ExecutionUnit> each : executionUnitGroups) {
            result.add(this.createExecutionGroup(databaseName, dataSourceName, each, connections.get(count++), connectionOffset, connectionMode));
        }
        return result;
    }

    private ExecutionGroup<T> createExecutionGroup(String databaseName, String dataSourceName, List<ExecutionUnit> executionUnits, C connection, int connectionOffset, ConnectionMode connectionMode) throws SQLException {
        LinkedList inputs = new LinkedList();
        ShardingSphereDatabase database = this.metaData.getDatabase(databaseName);
        ShardingSpherePreconditions.checkNotNull((Object)database, () -> new UnknownDatabaseException(databaseName));
        Map storageUnits = database.getResourceMetaData().getStorageUnits();
        DatabaseType databaseType = storageUnits.containsKey(dataSourceName) ? ((StorageUnit)storageUnits.get(dataSourceName)).getStorageType() : ((StorageUnit)storageUnits.values().iterator().next()).getStorageType();
        for (ExecutionUnit each : executionUnits) {
            inputs.add(this.sqlExecutionUnitBuilder.build(each, this.statementManager, connection, connectionOffset, connectionMode, this.option, databaseType));
        }
        return new ExecutionGroup(inputs);
    }

    @Generated
    public JDBCDriverType getType() {
        return this.type;
    }
}

