/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.sqlserver.visitor.statement.type;

import java.util.Collections;
import java.util.Optional;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.engine.sqlserver.visitor.statement.SQLServerStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dcl.LoginSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dcl.UserSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.AlterRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.CreateRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.DropRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.AlterUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.CreateUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.DropUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.dcl.SQLServerGrantStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.dcl.SQLServerRevertStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.dcl.SQLServerRevokeStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.dcl.login.SQLServerAlterLoginStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.dcl.login.SQLServerCreateLoginStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.dcl.login.SQLServerDropLoginStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.dcl.user.SQLServerDenyUserStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.dcl.user.SQLServerSetUserStatement;

public final class SQLServerDCLStatementVisitor
extends SQLServerStatementVisitor
implements DCLStatementVisitor {
    public SQLServerDCLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitGrant(SQLServerStatementParser.GrantContext ctx) {
        SQLServerGrantStatement result = new SQLServerGrantStatement(this.getDatabaseType());
        if (null != ctx.grantClassPrivilegesClause()) {
            this.findTableSegment(ctx.grantClassPrivilegesClause().onClassClause(), ctx.grantClassPrivilegesClause().classPrivileges()).ifPresent(optional -> result.getTables().add(optional));
            if (null != ctx.grantClassPrivilegesClause().classPrivileges().columnNames()) {
                for (SQLServerStatementParser.ColumnNamesContext each : ctx.grantClassPrivilegesClause().classPrivileges().columnNames()) {
                    result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)each)).getValue());
                }
            }
        }
        if (null != ctx.grantClassTypePrivilegesClause()) {
            this.findTableSegment(ctx.grantClassTypePrivilegesClause().onClassTypeClause()).ifPresent(optional -> result.getTables().add(optional));
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(SQLServerStatementParser.RevokeContext ctx) {
        SQLServerRevokeStatement result = new SQLServerRevokeStatement(this.getDatabaseType());
        if (null != ctx.revokeClassPrivilegesClause()) {
            this.findTableSegment(ctx.revokeClassPrivilegesClause().onClassClause(), ctx.revokeClassPrivilegesClause().classPrivileges()).ifPresent(optional -> result.getTables().add(optional));
            if (null != ctx.revokeClassPrivilegesClause().classPrivileges().columnNames()) {
                for (SQLServerStatementParser.ColumnNamesContext each : ctx.revokeClassPrivilegesClause().classPrivileges().columnNames()) {
                    result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)each)).getValue());
                }
            }
        }
        if (null != ctx.revokeClassTypePrivilegesClause()) {
            this.findTableSegment(ctx.revokeClassTypePrivilegesClause().onClassTypeClause()).ifPresent(optional -> result.getTables().add(optional));
        }
        return result;
    }

    @Override
    public ASTNode visitSecurable(SQLServerStatementParser.SecurableContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.name().getStart().getStartIndex(), ctx.name().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name())));
        SQLServerStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateUser(SQLServerStatementParser.CreateUserContext ctx) {
        CreateUserStatement result = new CreateUserStatement(this.getDatabaseType());
        if (null != ctx.createUserLoginClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserLoginClause().userName()));
        } else if (null != ctx.createUserWindowsPrincipalClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserWindowsPrincipalClause()));
        } else if (null != ctx.createUserLoginWindowsPrincipalClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserLoginWindowsPrincipalClause()));
        } else if (null != ctx.createUserWithoutLoginClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserWithoutLoginClause().userName()));
        } else if (null != ctx.createUserFromExternalProviderClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserFromExternalProviderClause().userName()));
        } else if (null != ctx.createUserWithDefaultSchema()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserWithDefaultSchema().userName()));
        } else if (null != ctx.createUserWithAzureActiveDirectoryPrincipalClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserWithAzureActiveDirectoryPrincipalClause().azureActiveDirectoryPrincipal().userName()));
        } else {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.userName()));
        }
        return result;
    }

    @Override
    public ASTNode visitUserName(SQLServerStatementParser.UserNameContext ctx) {
        UserSegment result = new UserSegment();
        String user = ((IdentifierValue)this.visit((ParseTree)ctx.ignoredNameIdentifier())).getValue();
        result.setUser(user);
        return result;
    }

    @Override
    public ASTNode visitIgnoredNameIdentifier(SQLServerStatementParser.IgnoredNameIdentifierContext ctx) {
        int identifierCount = ctx.identifier().size();
        return 1 == identifierCount ? (IdentifierValue)this.visit((ParseTree)ctx.identifier(0)) : new IdentifierValue(ctx.getText());
    }

    @Override
    public ASTNode visitCreateUserWindowsPrincipalClause(SQLServerStatementParser.CreateUserWindowsPrincipalClauseContext ctx) {
        if (null != ctx.windowsPrincipal()) {
            return (ASTNode)this.visit((ParseTree)ctx.windowsPrincipal().userName());
        }
        if (null != ctx.azureActiveDirectoryPrincipal()) {
            return (ASTNode)this.visit((ParseTree)ctx.azureActiveDirectoryPrincipal().userName());
        }
        return (ASTNode)this.visit((ParseTree)ctx.userName());
    }

    @Override
    public ASTNode visitCreateUserLoginWindowsPrincipalClause(SQLServerStatementParser.CreateUserLoginWindowsPrincipalClauseContext ctx) {
        return null == ctx.userName() ? (UserSegment)this.visit((ParseTree)ctx.windowsPrincipal(0)) : (UserSegment)this.visit((ParseTree)ctx.userName());
    }

    @Override
    public ASTNode visitAlterUser(SQLServerStatementParser.AlterUserContext ctx) {
        return new AlterUserStatement(this.getDatabaseType(), (UserSegment)this.visit((ParseTree)ctx.userName()));
    }

    @Override
    public ASTNode visitDeny(SQLServerStatementParser.DenyContext ctx) {
        SQLServerDenyUserStatement result = new SQLServerDenyUserStatement(this.getDatabaseType());
        if (null != ctx.denyClassPrivilegesClause()) {
            this.findTableSegment(ctx.denyClassPrivilegesClause().onClassClause(), ctx.denyClassPrivilegesClause().classPrivileges()).ifPresent(arg_0 -> ((SQLServerDenyUserStatement)result).setTable(arg_0));
            if (null != ctx.denyClassPrivilegesClause().classPrivileges().columnNames()) {
                for (SQLServerStatementParser.ColumnNamesContext each : ctx.denyClassPrivilegesClause().classPrivileges().columnNames()) {
                    result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)each)).getValue());
                }
            }
        }
        if (null != ctx.denyClassTypePrivilegesClause()) {
            this.findTableSegment(ctx.denyClassTypePrivilegesClause().onClassTypeClause()).ifPresent(arg_0 -> ((SQLServerDenyUserStatement)result).setTable(arg_0));
        }
        return result;
    }

    private Optional<SimpleTableSegment> findTableSegment(SQLServerStatementParser.OnClassClauseContext onClassClauseCtx, SQLServerStatementParser.ClassPrivilegesContext classPrivilegesCtx) {
        if (null == onClassClauseCtx) {
            return Optional.empty();
        }
        if (null != onClassClauseCtx.classItem() && null != onClassClauseCtx.classItem().OBJECT() || null != classPrivilegesCtx.privilegeType().get(0).objectPermission() || null != classPrivilegesCtx.privilegeType().get(0).PRIVILEGES()) {
            return Optional.of((SimpleTableSegment)this.visit((ParseTree)onClassClauseCtx.securable()));
        }
        return Optional.empty();
    }

    private Optional<SimpleTableSegment> findTableSegment(SQLServerStatementParser.OnClassTypeClauseContext ctx) {
        return null == ctx || null == ctx.classType() || null == ctx.classType().OBJECT() ? Optional.empty() : Optional.of((SimpleTableSegment)this.visit((ParseTree)ctx.securable()));
    }

    @Override
    public ASTNode visitDropUser(SQLServerStatementParser.DropUserContext ctx) {
        return new DropUserStatement(this.getDatabaseType(), Collections.singleton(((UserSegment)this.visit((ParseTree)ctx.userName())).getUser()));
    }

    @Override
    public ASTNode visitCreateRole(SQLServerStatementParser.CreateRoleContext ctx) {
        return new CreateRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterRole(SQLServerStatementParser.AlterRoleContext ctx) {
        return new AlterRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropRole(SQLServerStatementParser.DropRoleContext ctx) {
        return new DropRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateLogin(SQLServerStatementParser.CreateLoginContext ctx) {
        return new SQLServerCreateLoginStatement(this.getDatabaseType(), null == ctx.ignoredNameIdentifier() ? null : new LoginSegment(ctx.ignoredNameIdentifier().getStart().getStartIndex(), ctx.ignoredNameIdentifier().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.ignoredNameIdentifier())));
    }

    @Override
    public ASTNode visitAlterLogin(SQLServerStatementParser.AlterLoginContext ctx) {
        return new SQLServerAlterLoginStatement(this.getDatabaseType(), null == ctx.ignoredNameIdentifier() ? null : new LoginSegment(ctx.ignoredNameIdentifier().getStart().getStartIndex(), ctx.ignoredNameIdentifier().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.ignoredNameIdentifier())));
    }

    @Override
    public ASTNode visitDropLogin(SQLServerStatementParser.DropLoginContext ctx) {
        return new SQLServerDropLoginStatement(this.getDatabaseType(), new LoginSegment(ctx.ignoredNameIdentifier().getStart().getStartIndex(), ctx.ignoredNameIdentifier().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.ignoredNameIdentifier())));
    }

    @Override
    public ASTNode visitSetUser(SQLServerStatementParser.SetUserContext ctx) {
        return new SQLServerSetUserStatement(this.getDatabaseType(), null == ctx.stringLiterals() ? null : this.getUserSegment(ctx));
    }

    private UserSegment getUserSegment(SQLServerStatementParser.SetUserContext ctx) {
        UserSegment result = new UserSegment();
        result.setUser(((StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals())).getValue());
        result.setStartIndex(ctx.stringLiterals().start.getStartIndex());
        result.setStopIndex(ctx.stringLiterals().stop.getStopIndex());
        return result;
    }

    @Override
    public ASTNode visitRevert(SQLServerStatementParser.RevertContext ctx) {
        return new SQLServerRevertStatement(this.getDatabaseType());
    }
}

