/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.admin;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.transaction.ProxyBackendTransactionManager;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.ServerStatusFlagCalculator;

public final class MySQLComResetConnectionExecutor
implements CommandExecutor {
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() throws SQLException {
        ProxyBackendTransactionManager transactionManager = new ProxyBackendTransactionManager(this.connectionSession.getDatabaseConnectionManager());
        transactionManager.rollback();
        this.connectionSession.setAutoCommit(true);
        this.connectionSession.setDefaultIsolationLevel(null);
        this.connectionSession.setIsolationLevel(null);
        this.connectionSession.getServerPreparedStatementRegistry().clear();
        return Collections.singleton(new MySQLOKPacket(ServerStatusFlagCalculator.calculateFor(this.connectionSession, true)));
    }

    @Generated
    public MySQLComResetConnectionExecutor(ConnectionSession connectionSession) {
        this.connectionSession = connectionSession;
    }
}

