/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.oracle.visitor.statement.type;

import java.util.Optional;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DALStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementParser;
import org.apache.shardingsphere.sql.parser.engine.oracle.visitor.statement.OracleStatementVisitor;
import org.apache.shardingsphere.sql.parser.engine.oracle.visitor.statement.type.OracleDMLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ExplainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ShowStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.dal.OracleAlterResourceCostStatement;
import org.apache.shardingsphere.sql.parser.statement.oracle.dal.OracleSpoolStatement;

public final class OracleDALStatementVisitor
extends OracleStatementVisitor
implements DALStatementVisitor {
    public OracleDALStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitAlterResourceCost(OracleStatementParser.AlterResourceCostContext ctx) {
        return new OracleAlterResourceCostStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitExplain(OracleStatementParser.ExplainContext ctx) {
        OracleDMLStatementVisitor visitor = new OracleDMLStatementVisitor(this.getDatabaseType());
        this.getGlobalParameterMarkerSegments().addAll(visitor.getGlobalParameterMarkerSegments());
        this.getStatementParameterMarkerSegments().addAll(visitor.getStatementParameterMarkerSegments());
        ExplainStatement result = new ExplainStatement(this.getDatabaseType(), (SQLStatement)this.getExplainableSQLStatement(ctx, visitor).orElse(null));
        result.addParameterMarkers(ctx.getParent() instanceof OracleStatementParser.ExecuteContext ? this.getGlobalParameterMarkerSegments() : this.popAllStatementParameterMarkerSegments());
        result.getVariableNames().addAll(this.getVariableNames());
        return result;
    }

    private Optional<SQLStatement> getExplainableSQLStatement(OracleStatementParser.ExplainContext ctx, OracleDMLStatementVisitor visitor) {
        if (null != ctx.insert()) {
            return Optional.of((SQLStatement)visitor.visit((ParseTree)ctx.insert()));
        }
        if (null != ctx.delete()) {
            return Optional.of((SQLStatement)visitor.visit((ParseTree)ctx.delete()));
        }
        if (null != ctx.update()) {
            return Optional.of((SQLStatement)visitor.visit((ParseTree)ctx.update()));
        }
        if (null != ctx.select()) {
            return Optional.of((SQLStatement)visitor.visit((ParseTree)ctx.select()));
        }
        return Optional.empty();
    }

    @Override
    public ASTNode visitShow(OracleStatementParser.ShowContext ctx) {
        return new ShowStatement(this.getDatabaseType(), "");
    }

    @Override
    public ASTNode visitSpool(OracleStatementParser.SpoolContext ctx) {
        return new OracleSpoolStatement(this.getDatabaseType(), null == ctx.spoolFileName() ? null : ctx.spoolFileName().getText());
    }
}

