/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.show;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.process.Process;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.process.MySQLShowProcessListStatement;

public final class MySQLShowProcessListExecutor
implements DatabaseAdminQueryExecutor {
    private final MySQLShowProcessListStatement sqlStatement;
    private MergedResult mergedResult;

    public void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) {
        Collection processes = ProxyContext.getInstance().getContextManager().getPersistServiceFacade().getModeFacade().getProcessService().getProcessList();
        this.mergedResult = new LocalDataMergedResult((Collection)processes.stream().map(this::getQueryResultRow).collect(Collectors.toList()));
    }

    private LocalDataQueryResultRow getQueryResultRow(Process process) {
        ArrayList<Object> rowValues = new ArrayList<Object>(8);
        rowValues.add(process.getId());
        rowValues.add(process.getUsername());
        rowValues.add(process.getHostname());
        rowValues.add(process.getDatabaseName());
        rowValues.add(process.isIdle() ? "Sleep" : "Execute");
        rowValues.add(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - process.getStartMillis()));
        String sql = null;
        if (process.isIdle()) {
            rowValues.add("");
        } else {
            int processDoneCount = process.getCompletedUnitCount().get();
            String statePrefix = "Executing ";
            rowValues.add(statePrefix + processDoneCount + "/" + process.getTotalUnitCount().get());
            sql = process.getSql();
        }
        if (null != sql && sql.length() > 100 && !this.sqlStatement.isFull()) {
            sql = sql.substring(0, 100);
        }
        rowValues.add(null != sql ? sql : "");
        return new LocalDataQueryResultRow(rowValues.toArray());
    }

    public QueryResultMetaData getQueryResultMetaData() {
        ArrayList<RawQueryResultColumnMetaData> columns = new ArrayList<RawQueryResultColumnMetaData>(8);
        columns.add(new RawQueryResultColumnMetaData("", "Id", "Id", 12, "VARCHAR", 20, 0));
        columns.add(new RawQueryResultColumnMetaData("", "User", "User", 12, "VARCHAR", 20, 0));
        columns.add(new RawQueryResultColumnMetaData("", "Host", "Host", 12, "VARCHAR", 64, 0));
        columns.add(new RawQueryResultColumnMetaData("", "db", "db", 12, "VARCHAR", 64, 0));
        columns.add(new RawQueryResultColumnMetaData("", "Command", "Command", 12, "VARCHAR", 64, 0));
        columns.add(new RawQueryResultColumnMetaData("", "Time", "Time", 12, "VARCHAR", 10, 0));
        columns.add(new RawQueryResultColumnMetaData("", "State", "State", 12, "VARCHAR", 64, 0));
        columns.add(new RawQueryResultColumnMetaData("", "Info", "Info", 12, "VARCHAR", 120, 0));
        return new RawQueryResultMetaData(columns);
    }

    @Generated
    public MySQLShowProcessListExecutor(MySQLShowProcessListStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

