/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.show;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.database.MySQLShowCreateDatabaseStatement;

public final class MySQLShowCreateDatabaseExecutor
implements DatabaseAdminQueryExecutor {
    private final MySQLShowCreateDatabaseStatement sqlStatement;
    private MergedResult mergedResult;

    public void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) {
        this.mergedResult = new LocalDataMergedResult(this.getQueryResultRows(connectionSession, this.sqlStatement.getDatabaseName(), metaData));
    }

    private Collection<LocalDataQueryResultRow> getQueryResultRows(ConnectionSession connectionSession, String databaseName, ShardingSphereMetaData metaData) {
        ShardingSpherePreconditions.checkState((boolean)metaData.containsDatabase(databaseName), () -> new UnknownDatabaseException(databaseName));
        AuthorityRule authorityRule = (AuthorityRule)metaData.getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        AuthorityChecker authorityChecker = new AuthorityChecker(authorityRule, connectionSession.getConnectionContext().getGrantee());
        ShardingSpherePreconditions.checkState((boolean)authorityChecker.isAuthorized(databaseName), () -> new UnknownDatabaseException(databaseName));
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{databaseName, String.format("CREATE DATABASE `%s`;", databaseName)}));
    }

    public QueryResultMetaData getQueryResultMetaData() {
        List<RawQueryResultColumnMetaData> columnMetaData = Arrays.asList(new RawQueryResultColumnMetaData("", "Database", "Database", 12, "VARCHAR", 255, 0), new RawQueryResultColumnMetaData("", "Create Database", "Create Database", 12, "VARCHAR", 255, 0));
        return new RawQueryResultMetaData(columnMetaData);
    }

    @Generated
    public MySQLShowCreateDatabaseExecutor(MySQLShowCreateDatabaseStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    @Generated
    public MySQLShowCreateDatabaseStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

