/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss.command.query.extended.bind;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.opengauss.packet.command.bind.OpenGaussComBatchBindPacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLBindCompletePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.PostgreSQLCommand;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLBatchedStatementsExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLServerPreparedStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class OpenGaussComBatchBindExecutor
implements CommandExecutor {
    private final OpenGaussComBatchBindPacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() throws SQLException {
        this.connectionSession.getDatabaseConnectionManager().handleAutoCommit();
        PostgreSQLServerPreparedStatement preparedStatement = (PostgreSQLServerPreparedStatement)this.connectionSession.getServerPreparedStatementRegistry().getPreparedStatement((Object)this.packet.getStatementId());
        int updateCount = new PostgreSQLBatchedStatementsExecutor(this.connectionSession, preparedStatement, this.packet.readParameterSets(preparedStatement.getParameterTypes())).executeBatch();
        return Arrays.asList(PostgreSQLBindCompletePacket.getInstance(), this.createCommandComplete(preparedStatement.getSqlStatementContext().getSqlStatement(), updateCount));
    }

    private PostgreSQLCommandCompletePacket createCommandComplete(SQLStatement sqlStatement, int updateCount) {
        String sqlCommand = PostgreSQLCommand.valueOf(sqlStatement.getClass()).map(PostgreSQLCommand::getTag).orElse("");
        return new PostgreSQLCommandCompletePacket(sqlCommand, (long)updateCount);
    }

    @Generated
    public OpenGaussComBatchBindExecutor(OpenGaussComBatchBindPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

