/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.query;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.AllowNotUseDatabaseSQLStatementAttribute;

public final class QueryContext {
    private final SQLStatementContext sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private final HintValueContext hintValueContext;
    private final ConnectionContext connectionContext;
    private final ShardingSphereMetaData metaData;
    private final Collection<String> usedDatabaseNames;
    private final boolean useCache;

    public QueryContext(SQLStatementContext sqlStatementContext, String sql, List<Object> params, HintValueContext hintValueContext, ConnectionContext connectionContext, ShardingSphereMetaData metaData) {
        this(sqlStatementContext, sql, params, hintValueContext, connectionContext, metaData, false);
    }

    public QueryContext(SQLStatementContext sqlStatementContext, String sql, List<Object> params, HintValueContext hintValueContext, ConnectionContext connectionContext, ShardingSphereMetaData metaData, boolean useCache) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.parameters = params;
        this.hintValueContext = hintValueContext;
        this.connectionContext = connectionContext;
        this.metaData = metaData;
        this.usedDatabaseNames = this.getUsedDatabaseNames(sqlStatementContext, connectionContext, metaData);
        this.useCache = useCache;
    }

    private Collection<String> getUsedDatabaseNames(SQLStatementContext sqlStatementContext, ConnectionContext connectionContext, ShardingSphereMetaData metaData) {
        Collection databaseNamesFromSQL = sqlStatementContext.getTablesContext().getDatabaseNames();
        return databaseNamesFromSQL.isEmpty() ? (Collection)connectionContext.getCurrentDatabaseName().map(Collections::singletonList).orElseGet(() -> this.getUsedDatabaseNamesFromSQLStatementAttribute(sqlStatementContext.getSqlStatement(), metaData)) : databaseNamesFromSQL;
    }

    private List<String> getUsedDatabaseNamesFromSQLStatementAttribute(SQLStatement sqlStatement, ShardingSphereMetaData metaData) {
        Optional attribute = sqlStatement.getAttributes().findAttribute(AllowNotUseDatabaseSQLStatementAttribute.class);
        if (attribute.isPresent() && ((AllowNotUseDatabaseSQLStatementAttribute)attribute.get()).isAllowNotUseDatabase()) {
            return ((AllowNotUseDatabaseSQLStatementAttribute)attribute.get()).findDatabaseName().map(Collections::singletonList).orElseGet(() -> this.findAnyDatabaseName(metaData).map(Collections::singletonList).orElse(Collections.emptyList()));
        }
        return Collections.emptyList();
    }

    private Optional<String> findAnyDatabaseName(ShardingSphereMetaData metaData) {
        for (ShardingSphereDatabase each : metaData.getAllDatabases()) {
            if (!each.isComplete()) continue;
            return Optional.of(each.getName());
        }
        return Optional.empty();
    }

    public ShardingSphereDatabase getUsedDatabase() {
        ShardingSpherePreconditions.checkState((this.usedDatabaseNames.size() <= 1 ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException(String.format("Can not support multiple logic databases [%s]", Joiner.on((String)", ").join(this.usedDatabaseNames))));
        ShardingSpherePreconditions.checkState((this.usedDatabaseNames.size() == 1 ? 1 : 0) != 0, NoDatabaseSelectedException::new);
        String databaseName = this.usedDatabaseNames.iterator().next();
        ShardingSpherePreconditions.checkState((boolean)this.metaData.containsDatabase(databaseName), () -> new UnknownDatabaseException(databaseName));
        return this.metaData.getDatabase(databaseName);
    }

    public Collection<ShardingSphereDatabase> getUsedDatabases() {
        LinkedList<ShardingSphereDatabase> result = new LinkedList<ShardingSphereDatabase>();
        for (String each : this.usedDatabaseNames) {
            result.add(this.getDatabase(each));
        }
        return result;
    }

    private ShardingSphereDatabase getDatabase(String databaseName) {
        ShardingSpherePreconditions.checkNotNull((Object)databaseName, NoDatabaseSelectedException::new);
        ShardingSpherePreconditions.checkState((boolean)this.metaData.containsDatabase(databaseName), () -> new UnknownDatabaseException(databaseName));
        return this.metaData.getDatabase(databaseName);
    }

    @Generated
    public SQLStatementContext getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public HintValueContext getHintValueContext() {
        return this.hintValueContext;
    }

    @Generated
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Generated
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public Collection<String> getUsedDatabaseNames() {
        return this.usedDatabaseNames;
    }

    @Generated
    public boolean isUseCache() {
        return this.useCache;
    }
}

