/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.transformlet.impl;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtConstructor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.ClassInfo;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Comparator;

public class TtlPriorityBlockingQueueTransformlet
implements JavassistTransformlet {
    private static final Logger logger = Logger.getLogger(TtlPriorityBlockingQueueTransformlet.class);
    private static final String PRIORITY_BLOCKING_QUEUE_CLASS_NAME = "java.util.concurrent.PriorityBlockingQueue";
    private static final String PRIORITY_QUEUE_CLASS_NAME = "java.util.PriorityQueue";
    private static final String COMPARATOR_CLASS_NAME = "java.util.Comparator";
    private static final String COMPARATOR_FIELD_NAME = "comparator";
    private static final String WRAP_METHOD_NAME = "wrapComparator$by$ttl";
    private static final String AFTER_CODE_REWRITE_FILED = String.format("this.%s = %s.%s(this.%1$s);", "comparator", TtlPriorityBlockingQueueTransformlet.class.getName(), "wrapComparator$by$ttl");

    @Override
    public void doTransform(@NonNull ClassInfo classInfo) throws IOException, CannotCompileException, NotFoundException {
        String className = classInfo.getClassName();
        if (PRIORITY_BLOCKING_QUEUE_CLASS_NAME.equals(className)) {
            this.updatePriorityBlockingQueueClass(classInfo.getCtClass());
            classInfo.setModified();
        }
        if (PRIORITY_QUEUE_CLASS_NAME.equals(className)) {
            this.updateBlockingQueueClass(classInfo.getCtClass());
            classInfo.setModified();
        }
    }

    private void updatePriorityBlockingQueueClass(@NonNull CtClass clazz) throws CannotCompileException, NotFoundException {
        if (!TtlPriorityBlockingQueueTransformlet.haveComparatorField(clazz)) {
            logger.info("java.util.concurrent.PriorityBlockingQueue do not have field comparator, transform java.util.PriorityQueue instead.");
            return;
        }
        TtlPriorityBlockingQueueTransformlet.modifyConstructors(clazz);
    }

    private void updateBlockingQueueClass(@NonNull CtClass clazz) throws CannotCompileException, NotFoundException {
        CtClass classPriorityBlockingQueue = clazz.getClassPool().getCtClass(PRIORITY_BLOCKING_QUEUE_CLASS_NAME);
        if (TtlPriorityBlockingQueueTransformlet.haveComparatorField(classPriorityBlockingQueue)) {
            return;
        }
        logger.info("java.util.concurrent.PriorityBlockingQueue do not have field comparator, so need transform java.util.PriorityQueue");
        TtlPriorityBlockingQueueTransformlet.modifyConstructors(clazz);
    }

    private static boolean haveComparatorField(CtClass clazz) {
        try {
            clazz.getDeclaredField(COMPARATOR_FIELD_NAME);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private static void modifyConstructors(@NonNull CtClass clazz) throws NotFoundException, CannotCompileException {
        for (CtConstructor constructor : clazz.getDeclaredConstructors()) {
            CtClass[] parameterTypes = constructor.getParameterTypes();
            StringBuilder beforeCode = new StringBuilder();
            for (int i = 0; i < parameterTypes.length; ++i) {
                String paramTypeName = parameterTypes[i].getName();
                if (!COMPARATOR_CLASS_NAME.equals(paramTypeName)) continue;
                String code = String.format("$%d = %s.%s($%1$d);", i + 1, TtlPriorityBlockingQueueTransformlet.class.getName(), WRAP_METHOD_NAME);
                beforeCode.append(code);
            }
            if (beforeCode.length() > 0) {
                logger.info("insert code before constructor " + Utils.signatureOfMethod(constructor) + " of class " + constructor.getDeclaringClass().getName() + ": " + beforeCode);
                constructor.insertBefore(beforeCode.toString());
            }
            logger.info("insert code after constructor " + Utils.signatureOfMethod(constructor) + " of class " + constructor.getDeclaringClass().getName() + ": " + AFTER_CODE_REWRITE_FILED);
            constructor.insertAfter(AFTER_CODE_REWRITE_FILED);
        }
    }

    public static Comparator<Runnable> wrapComparator$by$ttl(Comparator<Runnable> comparator) {
        if (comparator == null) {
            return TtlExecutors.getTtlRunnableUnwrapComparatorForComparableRunnable();
        }
        return TtlExecutors.getTtlRunnableUnwrapComparator(comparator);
    }
}

