/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.metadata.schema;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.schema.SQLFederationSchema;

public final class SQLFederationDatabase
extends AbstractSchema {
    private final String name;
    private final Map<String, Schema> subSchemaMap;

    public SQLFederationDatabase(ShardingSphereDatabase database, DatabaseType protocolType) {
        this.name = database.getName();
        this.subSchemaMap = this.createSubSchemaMap(database, protocolType);
    }

    private Map<String, Schema> createSubSchemaMap(ShardingSphereDatabase database, DatabaseType protocolType) {
        CaseInsensitiveMap result = new CaseInsensitiveMap(database.getAllSchemas().size(), 1.0f);
        for (ShardingSphereSchema each : database.getAllSchemas()) {
            result.put(each.getName(), new SQLFederationSchema(each.getName(), each, protocolType));
        }
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Schema> getSubSchemaMap() {
        return this.subSchemaMap;
    }
}

