/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.geom.Dimension;
import com.cedarsoftware.util.geom.Insets;
import com.cedarsoftware.util.geom.Point;
import com.cedarsoftware.util.geom.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

final class DimensionConversions {
    private DimensionConversions() {
    }

    static String toString(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return dimension.getWidth() + "x" + dimension.getHeight();
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("width", dimension.getWidth());
        target.put("height", dimension.getHeight());
        return target;
    }

    static int[] toIntArray(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return new int[]{dimension.getWidth(), dimension.getHeight()};
    }

    static Integer toInteger(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return dimension.getWidth() * dimension.getHeight();
    }

    static Long toLong(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return (long)dimension.getWidth() * (long)dimension.getHeight();
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return BigInteger.valueOf((long)dimension.getWidth() * (long)dimension.getHeight());
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        throw new IllegalArgumentException("Unsupported conversion from Dimension to BigDecimal - no meaningful conversion exists.");
    }

    static Point toPoint(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return new Point(dimension.getWidth(), dimension.getHeight());
    }

    static Boolean toBoolean(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return dimension.getWidth() != 0 || dimension.getHeight() != 0;
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(DimensionConversions.toBoolean(from, converter));
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        throw new IllegalArgumentException("Unsupported conversion from Dimension to AtomicLong - no meaningful conversion exists.");
    }

    static Rectangle toRectangle(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return new Rectangle(0, 0, dimension.getWidth(), dimension.getHeight());
    }

    static Insets toInsets(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        int value = Math.min(dimension.getWidth(), dimension.getHeight());
        return new Insets(value, value, value, value);
    }
}

