/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.variable.charset;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.shardingsphere.database.exception.core.exception.data.InvalidParameterValueException;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.charset.CharsetVariableProvider;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.variable.charset.PostgreSQLCharacterSets;

public final class PostgreSQLCharsetVariableProvider
implements CharsetVariableProvider {
    public Collection<String> getCharsetVariables() {
        return Collections.singleton("client_encoding");
    }

    public Charset parseCharset(String variableValue) {
        String formattedValue = variableValue.trim().toLowerCase(Locale.ROOT);
        try {
            return "default".equals(formattedValue) ? Charset.defaultCharset() : PostgreSQLCharacterSets.findCharacterSet(formattedValue);
        }
        catch (IllegalArgumentException ignored) {
            throw new InvalidParameterValueException("client_encoding", formattedValue);
        }
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

