/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.firebird.handler.admin;

import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.firebird.handler.admin.executor.FirebirdSetVariableAdminExecutor;
import org.apache.shardingsphere.proxy.backend.firebird.handler.admin.executor.FirebirdShowVariableExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ShowStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class FirebirdAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext sqlStatementContext, String sql, String databaseName, List<Object> parameters) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof SelectStatement) {
            return Optional.empty();
        }
        if (sqlStatement instanceof SetStatement) {
            return Optional.of(new FirebirdSetVariableAdminExecutor((SetStatement)sqlStatement));
        }
        if (sqlStatement instanceof ShowStatement) {
            return Optional.of(new FirebirdShowVariableExecutor((ShowStatement)sqlStatement));
        }
        return Optional.empty();
    }

    public String getDatabaseType() {
        return "Firebird";
    }
}

