/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.firebird.metadata.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public final class FirebirdBlobInfoRegistry {
    private static final Map<String, Map<String, Integer>> BLOB_COLUMNS = new ConcurrentHashMap<String, Map<String, Integer>>();

    public static void refreshTable(String schemaName, String tableName, Map<String, Integer> blobColumns) {
        if (null == tableName) {
            return;
        }
        String tableKey = FirebirdBlobInfoRegistry.buildTableKey(schemaName, tableName);
        if (null == blobColumns || blobColumns.isEmpty()) {
            BLOB_COLUMNS.remove(tableKey);
            return;
        }
        HashMap<String, Integer> normalizedColumns = new HashMap<String, Integer>(blobColumns.size(), 1.0f);
        for (Map.Entry<String, Integer> entry : blobColumns.entrySet()) {
            if (null == entry.getKey()) continue;
            normalizedColumns.put(FirebirdBlobInfoRegistry.toKey(entry.getKey()), entry.getValue());
        }
        if (normalizedColumns.isEmpty()) {
            BLOB_COLUMNS.remove(tableKey);
            return;
        }
        BLOB_COLUMNS.put(tableKey, Collections.unmodifiableMap(normalizedColumns));
    }

    public static boolean isBlobColumn(String schemaName, String tableName, String columnName) {
        if (null == tableName || null == columnName) {
            return false;
        }
        Map<String, Integer> blobColumns = BLOB_COLUMNS.get(FirebirdBlobInfoRegistry.buildTableKey(schemaName, tableName));
        return null != blobColumns && blobColumns.containsKey(FirebirdBlobInfoRegistry.toKey(columnName));
    }

    public static OptionalInt findBlobSubtype(String schemaName, String tableName, String columnName) {
        if (null == tableName || null == columnName) {
            return OptionalInt.empty();
        }
        Map<String, Integer> blobColumns = BLOB_COLUMNS.get(FirebirdBlobInfoRegistry.buildTableKey(schemaName, tableName));
        if (null == blobColumns) {
            return OptionalInt.empty();
        }
        Integer subtype = blobColumns.get(FirebirdBlobInfoRegistry.toKey(columnName));
        return null == subtype ? OptionalInt.empty() : OptionalInt.of(subtype);
    }

    private static String buildTableKey(String schemaName, String tableName) {
        String schemaKey = null == schemaName ? "" : FirebirdBlobInfoRegistry.toKey(schemaName);
        String logicTable = FirebirdBlobInfoRegistry.trimToLogicTableName(tableName);
        return schemaKey + "." + FirebirdBlobInfoRegistry.toKey(logicTable);
    }

    private static String trimToLogicTableName(String tableName) {
        int end;
        for (end = tableName.length() - 1; end >= 0 && !Character.isLetter(tableName.charAt(end)); --end) {
        }
        return end < 0 ? tableName : tableName.substring(0, end + 1);
    }

    private static String toKey(String value) {
        return value.toUpperCase(Locale.ENGLISH);
    }

    @Generated
    private FirebirdBlobInfoRegistry() {
    }
}

