/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.type;

import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.DatabaseRuleOperator;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.distsql.statement.type.rdl.rule.database.DatabaseRuleDefinitionStatement;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.DatabaseRuleConfigurationEmptyChecker;
import org.apache.shardingsphere.infra.config.rule.scope.DatabaseRuleConfiguration;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;

public final class AlterDatabaseRuleOperator
implements DatabaseRuleOperator {
    private final ContextManager contextManager;
    private final DatabaseRuleAlterExecutor executor;

    @Override
    public void operate(DatabaseRuleDefinitionStatement sqlStatement, ShardingSphereDatabase database, RuleConfiguration currentRuleConfig) {
        Object toBeAlteredRuleConfig = this.executor.buildToBeAlteredRuleConfiguration(sqlStatement);
        MetaDataManagerPersistService metaDataManagerPersistService = this.contextManager.getPersistServiceFacade().getModeFacade().getMetaDataManagerService();
        metaDataManagerPersistService.alterRuleConfiguration(database, database.decorateRuleConfiguration(toBeAlteredRuleConfig));
        Object toBeDroppedRuleConfig = this.executor.buildToBeDroppedRuleConfiguration(toBeAlteredRuleConfig);
        if (null != toBeDroppedRuleConfig && !((DatabaseRuleConfigurationEmptyChecker)TypedSPILoader.getService(DatabaseRuleConfigurationEmptyChecker.class, toBeAlteredRuleConfig.getClass())).isEmpty((DatabaseRuleConfiguration)toBeDroppedRuleConfig)) {
            metaDataManagerPersistService.removeRuleConfigurationItem(database, toBeDroppedRuleConfig);
        }
    }

    @Generated
    public AlterDatabaseRuleOperator(ContextManager contextManager, DatabaseRuleAlterExecutor executor) {
        this.contextManager = contextManager;
        this.executor = executor;
    }
}

