/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.persist.service;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.ComputeNodeData;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataFactory;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeData;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeDataSwapper;
import org.apache.shardingsphere.infra.state.instance.InstanceState;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.global.node.compute.label.LabelNodePath;
import org.apache.shardingsphere.mode.node.path.type.global.node.compute.status.OnlineNodePath;
import org.apache.shardingsphere.mode.node.path.type.global.node.compute.status.StatusNodePath;
import org.apache.shardingsphere.mode.node.path.type.global.node.compute.workerid.ComputeNodeWorkerIDNodePath;
import org.apache.shardingsphere.mode.persist.service.ComputeNodePersistService;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterComputeNodePersistService
implements ComputeNodePersistService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterComputeNodePersistService.class);
    private final ClusterPersistRepository repository;

    public void registerOnline(ComputeNodeInstance computeNodeInstance) {
        this.persistOnline(computeNodeInstance);
        this.updateState(computeNodeInstance.getMetaData().getId(), computeNodeInstance.getState().getCurrentState());
        this.persistLabels(computeNodeInstance.getMetaData().getId(), computeNodeInstance.getLabels());
    }

    private void persistOnline(ComputeNodeInstance computeNodeInstance) {
        ComputeNodeData computeNodeData = new ComputeNodeData(computeNodeInstance.getMetaData().getDatabaseName(), computeNodeInstance.getMetaData().getAttributes(), computeNodeInstance.getMetaData().getVersion());
        this.repository.persistEphemeral(NodePathGenerator.toPath((NodePath)new OnlineNodePath(computeNodeInstance.getMetaData().getType(), computeNodeInstance.getMetaData().getId())), YamlEngine.marshal((Object)new YamlComputeNodeDataSwapper().swapToYamlConfiguration(computeNodeData)));
    }

    public void offline(ComputeNodeInstance computeNodeInstance) {
        this.repository.delete(NodePathGenerator.toPath((NodePath)new OnlineNodePath(computeNodeInstance.getMetaData().getType(), computeNodeInstance.getMetaData().getId())));
    }

    public ComputeNodeInstance loadInstance(InstanceMetaData instanceMetaData) {
        ComputeNodeInstance result = new ComputeNodeInstance(instanceMetaData);
        InstanceState.get((String)this.loadState(instanceMetaData.getId())).ifPresent(arg_0 -> ((ComputeNodeInstance)result).switchState(arg_0));
        result.getLabels().addAll(this.loadLabels(instanceMetaData.getId()));
        this.loadWorkerId(instanceMetaData.getId()).ifPresent(arg_0 -> ((ComputeNodeInstance)result).setWorkerId(arg_0));
        return result;
    }

    private String loadState(String instanceId) {
        return this.repository.query(NodePathGenerator.toPath((NodePath)new StatusNodePath(instanceId)));
    }

    private Collection<String> loadLabels(String instanceId) {
        String yamlContent = this.repository.query(NodePathGenerator.toPath((NodePath)new LabelNodePath(instanceId)));
        return Strings.isNullOrEmpty((String)yamlContent) ? Collections.emptyList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class);
    }

    public void updateState(String instanceId, InstanceState instanceState) {
        this.repository.persistEphemeral(NodePathGenerator.toPath((NodePath)new StatusNodePath(instanceId)), instanceState.name());
    }

    public void persistLabels(String instanceId, Collection<String> labels) {
        this.repository.persistEphemeral(NodePathGenerator.toPath((NodePath)new LabelNodePath(instanceId)), YamlEngine.marshal(labels));
    }

    public void persistWorkerId(String instanceId, int workerId) {
        this.repository.persistEphemeral(NodePathGenerator.toPath((NodePath)new ComputeNodeWorkerIDNodePath(instanceId)), String.valueOf(workerId));
    }

    public Optional<Integer> loadWorkerId(String instanceId) {
        try {
            String workerId = this.repository.query(NodePathGenerator.toPath((NodePath)new ComputeNodeWorkerIDNodePath(instanceId)));
            return Strings.isNullOrEmpty((String)workerId) ? Optional.empty() : Optional.of(Integer.valueOf(workerId));
        }
        catch (NumberFormatException ex) {
            log.error("Invalid worker id for instance: {}", (Object)instanceId);
            return Optional.empty();
        }
    }

    public Collection<Integer> getAssignedWorkerIds() {
        List instanceIds = this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new ComputeNodeWorkerIDNodePath(null)));
        return instanceIds.stream().map(each -> this.repository.query(NodePathGenerator.toPath((NodePath)new ComputeNodeWorkerIDNodePath(each)))).filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toSet());
    }

    public Collection<ComputeNodeInstance> loadAllInstances() {
        return Arrays.stream(InstanceType.values()).flatMap(each -> this.loadInstances((InstanceType)each).stream()).collect(Collectors.toList());
    }

    private Collection<ComputeNodeInstance> loadInstances(InstanceType instanceType) {
        LinkedList<ComputeNodeInstance> result = new LinkedList<ComputeNodeInstance>();
        for (String each : this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new OnlineNodePath(instanceType, null)))) {
            String value = this.repository.query(NodePathGenerator.toPath((NodePath)new OnlineNodePath(instanceType, each)));
            if (Strings.isNullOrEmpty((String)value)) continue;
            result.add(this.loadInstance(InstanceMetaDataFactory.create((String)each, (InstanceType)instanceType, (ComputeNodeData)new YamlComputeNodeDataSwapper().swapToObject((YamlComputeNodeData)YamlEngine.unmarshal((String)value, YamlComputeNodeData.class)))));
        }
        return result;
    }

    @Generated
    public ClusterComputeNodePersistService(ClusterPersistRepository repository) {
        this.repository = repository;
    }
}

