/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.List;
import lombok.Generated;

public final class RowStatistics {
    private final String uniqueKey;
    private final List<Object> rows;

    public RowStatistics(List<Object> rows) {
        this.uniqueKey = this.generateUniqueKey(rows);
        this.rows = rows;
    }

    private String generateUniqueKey(List<Object> rows) {
        StringBuilder uniqueKeyText = new StringBuilder();
        for (Object each : rows) {
            if (null != each) {
                uniqueKeyText.append(each);
            }
            uniqueKeyText.append('|');
        }
        return this.useMd5GenerateUniqueKey(uniqueKeyText);
    }

    private String useMd5GenerateUniqueKey(StringBuilder uniqueKeyText) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(StandardCharsets.UTF_8.encode(uniqueKeyText.toString()));
        return String.format("%032x", new BigInteger(1, md5.digest()));
    }

    @Generated
    public RowStatistics(String uniqueKey, List<Object> rows) {
        this.uniqueKey = uniqueKey;
        this.rows = rows;
    }

    @Generated
    public String getUniqueKey() {
        return this.uniqueKey;
    }

    @Generated
    public List<Object> getRows() {
        return this.rows;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RowStatistics)) {
            return false;
        }
        RowStatistics other = (RowStatistics)o;
        String this$uniqueKey = this.getUniqueKey();
        String other$uniqueKey = other.getUniqueKey();
        return !(this$uniqueKey == null ? other$uniqueKey != null : !this$uniqueKey.equals(other$uniqueKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uniqueKey = this.getUniqueKey();
        result = result * 59 + ($uniqueKey == null ? 43 : $uniqueKey.hashCode());
        return result;
    }
}

