/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.util;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.schema.DialectSchemaOption;
import org.apache.shardingsphere.database.connector.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;

public final class SystemSchemaUtils {
    public static boolean containsSystemSchema(DatabaseType databaseType, Collection<String> schemaNames, ShardingSphereDatabase database) {
        DialectSchemaOption schemaOption = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getSchemaOption();
        if (database.isComplete() && !schemaOption.getDefaultSchema().isPresent()) {
            return false;
        }
        SystemDatabase systemDatabase = new SystemDatabase(databaseType);
        for (String each : schemaNames) {
            if (!systemDatabase.getSystemSchemas().contains(each)) continue;
            return true;
        }
        return !schemaOption.getDefaultSchema().isPresent() && systemDatabase.getSystemSchemas().contains(database.getName());
    }

    public static boolean isSystemSchema(ShardingSphereDatabase database) {
        DialectSchemaOption schemaOption = new DatabaseTypeRegistry(database.getProtocolType()).getDialectDatabaseMetaData().getSchemaOption();
        return (!database.isComplete() || schemaOption.getDefaultSchema().isPresent()) && new SystemDatabase(database.getProtocolType()).getSystemSchemas().contains(database.getName());
    }

    public static boolean isDriverQuerySystemCatalog(DatabaseType databaseType, Collection<ProjectionSegment> projections) {
        if (1 != projections.size()) {
            return false;
        }
        ProjectionSegment firstProjection = projections.iterator().next();
        if (!(firstProjection instanceof ExpressionProjectionSegment)) {
            return false;
        }
        Optional driverQuerySystemCatalogOption = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getDriverQuerySystemCatalogOption();
        return driverQuerySystemCatalogOption.map(optional -> optional.isSystemCatalogQueryExpressions(((ExpressionProjectionSegment)firstProjection).getText())).orElse(false);
    }

    @Generated
    private SystemSchemaUtils() {
    }
}

