/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.api.ShardingSphereDataSourceFactory;
import org.apache.shardingsphere.driver.api.yaml.YamlShardingSphereDataSourceFactory;
import org.apache.shardingsphere.driver.jdbc.core.driver.ShardingSphereURLLoadEngine;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.url.core.ShardingSphereURL;

public final class DriverDataSourceCache {
    private final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();

    public DataSource get(String url, String urlPrefix) {
        if (this.dataSourceMap.containsKey(url)) {
            return this.dataSourceMap.get(url);
        }
        return this.dataSourceMap.computeIfAbsent(url, driverUrl -> this.createDataSource(ShardingSphereURL.parse((String)driverUrl.substring(urlPrefix.length()))));
    }

    private <T extends Throwable> DataSource createDataSource(ShardingSphereURL url) throws T {
        try {
            ShardingSphereURLLoadEngine urlLoadEngine = new ShardingSphereURLLoadEngine(url);
            Object loadedContent = urlLoadEngine.loadContent();
            return loadedContent instanceof ModeConfiguration ? ShardingSphereDataSourceFactory.createDataSource(url.getQueryProps().getProperty("databaseName"), (ModeConfiguration)loadedContent) : YamlShardingSphereDataSourceFactory.createDataSource((byte[])loadedContent);
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        catch (SQLException ex) {
            throw ex;
        }
    }

    @Generated
    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }
}

