/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;

public final class DropViewStatementBinder
implements SQLStatementBinder<DropViewStatement> {
    @Override
    public DropViewStatement bind(DropViewStatement sqlStatement, SQLStatementBinderContext binderContext) {
        Collection boundViews = sqlStatement.getViews().stream().map(each -> SimpleTableSegmentBinder.bind(each, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)LinkedHashMultimap.create())).collect(Collectors.toList());
        return this.copy(sqlStatement, boundViews);
    }

    private DropViewStatement copy(DropViewStatement sqlStatement, Collection<SimpleTableSegment> boundViews) {
        DropViewStatement result = new DropViewStatement(sqlStatement.getDatabaseType());
        result.getViews().addAll(boundViews);
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }
}

