/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.opengauss.metadata.database.option;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.table.DialectDriverQuerySystemCatalogOption;

public final class OpenGaussDriverQuerySystemCatalogOption
implements DialectDriverQuerySystemCatalogOption {
    private static final Collection<String> SYSTEM_CATALOG_QUERY_EXPRESSIONS = new CaseInsensitiveSet(Arrays.asList("version()", "intervaltonum(gs_password_deadline())", "gs_password_notifytime()"));
    private static final String DATABASE_DATA_TABLE = "pg_database";
    private static final String TABLE_DATA_TABLE = "pg_tables";
    private static final String ROLE_DATA_TABLE = "pg_roles";
    private static final Collection<String> SYSTEM_CATALOG_TABLES = new CaseInsensitiveSet(Arrays.asList("pg_database", "pg_tables", "pg_roles"));

    public boolean isSystemCatalogQueryExpressions(String projectionExpression) {
        return SYSTEM_CATALOG_QUERY_EXPRESSIONS.contains(projectionExpression);
    }

    public boolean isSystemTable(String tableName) {
        return SYSTEM_CATALOG_TABLES.contains(tableName);
    }

    public boolean isDatabaseDataTable(String tableName) {
        return DATABASE_DATA_TABLE.equalsIgnoreCase(tableName);
    }

    public boolean isTableDataTable(String tableName) {
        return TABLE_DATA_TABLE.equalsIgnoreCase(tableName);
    }

    public boolean isRoleDataTable(String tableName) {
        return ROLE_DATA_TABLE.equalsIgnoreCase(tableName);
    }

    public String getDatCompatibility() {
        return "PG";
    }
}

