/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.url.classpath;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.url.spi.ShardingSphereLocalFileURLLoader;

public final class ClassPathLocalFileURLLoader
implements ShardingSphereLocalFileURLLoader {
    /*
     * Enabled aggressive exception aggregation
     */
    public String load(String configSubject, Properties queryProps) {
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(configSubject);){
            String string;
            Objects.requireNonNull(inputStream);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            return string;
        }
    }

    public String getType() {
        return "classpath:";
    }
}

