/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.oracle.metadata.database.option;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.datatype.DefaultDataTypeOption;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.datatype.DialectDataTypeOption;

public final class OracleDataTypeOption
implements DialectDataTypeOption {
    private static final Map<String, Integer> EXTRA_DATA_TYPES = OracleDataTypeOption.setUpExtraDataTypes();
    private final DialectDataTypeOption delegate = new DefaultDataTypeOption();

    private static Map<String, Integer> setUpExtraDataTypes() {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        result.put("SMALLINT", 5);
        result.put("TINYINT", -6);
        result.put("INT", 4);
        result.put("TEXT", -1);
        result.put("CHARACTER", 1);
        result.put("VARCHAR2", 12);
        result.put("DATETIME", 93);
        result.put("ROWID", -8);
        result.put("BINARY_DOUBLE", 8);
        result.put("BINARY_FLOAT", 6);
        result.put("NUMBER", 2);
        return result;
    }

    public Map<String, Integer> getExtraDataTypes() {
        return EXTRA_DATA_TYPES;
    }

    public Optional<Class<?>> findExtraSQLTypeClass(int dataType, boolean unsigned) {
        return Optional.empty();
    }

    public boolean isIntegerDataType(int sqlType) {
        return this.delegate.isIntegerDataType(sqlType);
    }

    public boolean isStringDataType(int sqlType) {
        return this.delegate.isStringDataType(sqlType);
    }

    public boolean isBinaryDataType(int sqlType) {
        return this.delegate.isBinaryDataType(sqlType);
    }
}

