/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.FunctionNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.RoutineBodySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttributes;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;

public class CreateFunctionStatement
extends DDLStatement {
    private FunctionNameSegment functionName;
    private RoutineBodySegment routineBody;
    private final List<ExpressionSegment> dynamicSqlStatementExpressions = new ArrayList<ExpressionSegment>();
    private SQLStatementAttributes attributes;

    public CreateFunctionStatement(DatabaseType databaseType) {
        super(databaseType);
    }

    public Optional<FunctionNameSegment> getFunctionName() {
        return Optional.ofNullable(this.functionName);
    }

    public Optional<RoutineBodySegment> getRoutineBody() {
        return Optional.ofNullable(this.routineBody);
    }

    @Override
    public void buildAttributes() {
        this.attributes = new SQLStatementAttributes(new TableSQLStatementAttribute(this.getRoutineBody().map(optional -> new TableExtractor().extractExistTableFromRoutineBody((RoutineBodySegment)optional)).orElseGet(Collections::emptyList)));
    }

    @Generated
    public List<ExpressionSegment> getDynamicSqlStatementExpressions() {
        return this.dynamicSqlStatementExpressions;
    }

    @Override
    @Generated
    public SQLStatementAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setFunctionName(FunctionNameSegment functionName) {
        this.functionName = functionName;
    }

    @Generated
    public void setRoutineBody(RoutineBodySegment routineBody) {
        this.routineBody = routineBody;
    }

    @Generated
    public void setAttributes(SQLStatementAttributes attributes) {
        this.attributes = attributes;
    }
}

