/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import com.google.errorprone.annotations.ThreadSafe;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.builder.ShardingSphereStatisticsFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;

@ThreadSafe
public final class MetaDataContexts {
    private final AtomicReference<ShardingSphereMetaData> metaData = new AtomicReference();
    private final AtomicReference<ShardingSphereStatistics> statistics = new AtomicReference();

    public MetaDataContexts(ShardingSphereMetaData metaData, ShardingSphereStatistics statistics) {
        this.metaData.set(metaData);
        this.statistics.set(statistics);
    }

    public ShardingSphereMetaData getMetaData() {
        return this.metaData.get();
    }

    public ShardingSphereStatistics getStatistics() {
        return this.statistics.get();
    }

    public void update(MetaDataContexts newMetaDataContexts) {
        this.metaData.set(newMetaDataContexts.getMetaData());
        this.statistics.set(newMetaDataContexts.getStatistics());
    }

    public void update(ShardingSphereMetaData metaData, MetaDataPersistFacade metaDataPersistFacade) {
        this.metaData.set(metaData);
        this.statistics.set(ShardingSphereStatisticsFactory.create((ShardingSphereMetaData)metaData, (ShardingSphereStatistics)metaDataPersistFacade.getStatisticsService().load(metaData)));
    }
}

