/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.checker.sql.table;

import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.syntax.UnsupportedDropCascadeTableException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;

public final class SingleDropTableSupportedChecker
implements SupportedSQLChecker<SQLStatementContext, SingleRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement() instanceof DropTableStatement;
    }

    public void check(SingleRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, SQLStatementContext sqlStatementContext) {
        ShardingSpherePreconditions.checkState((!((DropTableStatement)sqlStatementContext.getSqlStatement()).isContainsCascade() ? 1 : 0) != 0, UnsupportedDropCascadeTableException::new);
    }
}

