/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleChangedItemType;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.yaml.config.strategy.sharding.YamlShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.YamlShardingStrategyConfigurationSwapper;

public final class DefaultDatabaseShardingStrategyChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShardingRuleConfiguration, ShardingStrategyConfiguration> {
    public ShardingStrategyConfiguration swapRuleItemConfiguration(String itemName, String yamlContent) {
        return new YamlShardingStrategyConfigurationSwapper().swapToObject((YamlShardingStrategyConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlShardingStrategyConfiguration.class));
    }

    public ShardingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShardingRule.class).map(ShardingRule::getConfiguration).orElseGet(ShardingRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(String itemName, ShardingRuleConfiguration currentRuleConfig, ShardingStrategyConfiguration toBeChangedItemConfig) {
        currentRuleConfig.setDefaultDatabaseShardingStrategy(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(String itemName, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.setDefaultDatabaseShardingStrategy(null);
    }

    public RuleChangedItemType getType() {
        return new RuleChangedItemType("sharding", "default_database_strategy");
    }
}

