/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.metadata.data.loader;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.DialectMetaDataLoader;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoaderMaterial;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.type.TableMetaDataLoader;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.SchemaMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.TableMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.database.datatype.DataTypeRegistry;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaDataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaDataLoader.class);
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShardingSphere-SchemaMetaDataLoaderEngine-%d").build());

    public static Map<String, SchemaMetaData> load(Collection<MetaDataLoaderMaterial> materials) throws SQLException {
        LinkedHashMap<String, SchemaMetaData> result = new LinkedHashMap<String, SchemaMetaData>(materials.size(), 1.0f);
        LinkedList<Future<Collection>> futures = new LinkedList<Future<Collection>>();
        for (MetaDataLoaderMaterial metaDataLoaderMaterial : materials) {
            DataTypeRegistry.load(metaDataLoaderMaterial.getDataSource(), metaDataLoaderMaterial.getStorageType().getType());
            futures.add(EXECUTOR_SERVICE.submit(() -> MetaDataLoader.load(metaDataLoaderMaterial)));
        }
        try {
            for (Future future : futures) {
                MetaDataLoader.merge(result, (Collection)future.get());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof SQLException) {
                throw (SQLException)ex.getCause();
            }
            throw new SQLException(ex);
        }
        return result;
    }

    private static Collection<SchemaMetaData> load(MetaDataLoaderMaterial material) throws SQLException {
        Optional<DialectMetaDataLoader> dialectLoader = DatabaseTypedSPILoader.findService(DialectMetaDataLoader.class, material.getStorageType());
        if (dialectLoader.isPresent()) {
            try {
                return dialectLoader.get().load(material);
            }
            catch (SQLException ex) {
                log.debug("{} Dialect load schema meta data error, load by default.", (Object)material.getStorageType(), (Object)ex);
            }
        }
        return MetaDataLoader.loadByDefault(material);
    }

    private static Collection<SchemaMetaData> loadByDefault(MetaDataLoaderMaterial material) throws SQLException {
        LinkedList<TableMetaData> tableMetaData = new LinkedList<TableMetaData>();
        for (String each : material.getActualTableNames()) {
            TableMetaDataLoader.load(material.getDataSource(), each, material.getStorageType()).ifPresent(tableMetaData::add);
        }
        return Collections.singleton(new SchemaMetaData(material.getDefaultSchemaName(), tableMetaData));
    }

    private static void merge(Map<String, SchemaMetaData> schemaMetaDataMap, Collection<SchemaMetaData> addedSchemaMetaDataList) {
        for (SchemaMetaData each : addedSchemaMetaDataList) {
            SchemaMetaData schemaMetaData = schemaMetaDataMap.computeIfAbsent(each.getName(), key -> new SchemaMetaData(each.getName(), new LinkedList<TableMetaData>()));
            schemaMetaData.getTables().addAll(each.getTables());
        }
    }

    @Generated
    private MetaDataLoader() {
    }
}

