/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.logs;

import java.util.Collection;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.logs.LogReusableDataMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.data.LogRecordData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.export.LogRecordExporter;

@ThreadSafe
public final class OtlpGrpcLogRecordExporter
implements LogRecordExporter {
    private final GrpcExporterBuilder<Marshaler> builder;
    private final GrpcExporter<Marshaler> delegate;
    private final LogReusableDataMarshaler marshaler;

    public static OtlpGrpcLogRecordExporter getDefault() {
        return OtlpGrpcLogRecordExporter.builder().build();
    }

    public static OtlpGrpcLogRecordExporterBuilder builder() {
        return new OtlpGrpcLogRecordExporterBuilder();
    }

    OtlpGrpcLogRecordExporter(GrpcExporterBuilder<Marshaler> builder, GrpcExporter<Marshaler> delegate, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.marshaler = new LogReusableDataMarshaler(memoryMode, delegate::export);
    }

    public OtlpGrpcLogRecordExporterBuilder toBuilder() {
        return new OtlpGrpcLogRecordExporterBuilder(this.builder.copy(), this.marshaler.getMemoryMode());
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        return this.marshaler.export(logs);
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpGrpcLogRecordExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("memoryMode=" + (Object)((Object)this.marshaler.getMemoryMode()));
        return joiner.toString();
    }
}

