/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.advisor.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.apache.shardingsphere.agent.core.advisor.config.AdvisorConfiguration;
import org.apache.shardingsphere.agent.core.advisor.config.yaml.loader.YamlAdvisorsConfigurationLoader;
import org.apache.shardingsphere.agent.core.advisor.config.yaml.swapper.YamlAdvisorsConfigurationSwapper;

public final class AdvisorConfigurationLoader {
    private static final Logger LOGGER = Logger.getLogger(AdvisorConfigurationLoader.class.getName());

    public static Map<String, AdvisorConfiguration> load(Collection<JarFile> pluginJars, Collection<String> pluginTypes) {
        HashMap<String, AdvisorConfiguration> result = new HashMap<String, AdvisorConfiguration>();
        for (String each : pluginTypes) {
            InputStream advisorsResourceStream = AdvisorConfigurationLoader.getResourceStream(pluginJars, each);
            if (null == advisorsResourceStream) {
                LOGGER.log(Level.WARNING, "The configuration file for advice of plugin `{0}` is not found", new String[]{each});
            }
            Optional.ofNullable(advisorsResourceStream).ifPresent(optional -> AdvisorConfigurationLoader.mergeConfigurations(result, YamlAdvisorsConfigurationSwapper.swap(YamlAdvisorsConfigurationLoader.load(optional), each)));
            if (null == advisorsResourceStream) continue;
            try {
                advisorsResourceStream.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private static InputStream getResourceStream(Collection<JarFile> pluginJars, String pluginType) {
        String entryName = String.join((CharSequence)"/", "META-INF", "conf", AdvisorConfigurationLoader.getFileName(pluginType));
        for (JarFile each : pluginJars) {
            JarEntry entry = each.getJarEntry(entryName);
            if (null == entry) continue;
            try {
                return each.getInputStream(entry);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private static String getFileName(String pluginType) {
        return String.join((CharSequence)"-", pluginType.toLowerCase(), "advisors.yaml");
    }

    private static void mergeConfigurations(Map<String, AdvisorConfiguration> advisorConfigMap, Collection<AdvisorConfiguration> toBeMergedAdvisorConfigs) {
        for (AdvisorConfiguration each : toBeMergedAdvisorConfigs) {
            advisorConfigMap.computeIfAbsent(each.getTargetClassName(), key -> new AdvisorConfiguration(each.getTargetClassName())).getAdvisors().addAll(each.getAdvisors());
        }
    }

    @Generated
    private AdvisorConfigurationLoader() {
    }
}

