/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.provider;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.tieredstore.MessageStoreConfig;
import org.apache.rocketmq.tieredstore.MessageStoreExecutor;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.provider.FileSegment;
import org.apache.rocketmq.tieredstore.stream.FileSegmentInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryFileSegment
extends FileSegment {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    protected final ByteBuffer memStore = ByteBuffer.allocate(10000);
    protected CompletableFuture<Boolean> blocker;
    protected int size = 0;
    protected boolean checkSize = true;

    public MemoryFileSegment(MessageStoreConfig storeConfig, FileSegmentType fileType, String filePath, long baseOffset, MessageStoreExecutor executor) {
        super(storeConfig, fileType, filePath, baseOffset, executor);
        this.memStore.position((int)this.getSize());
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public void createFile() {
    }

    public ByteBuffer getMemStore() {
        return this.memStore;
    }

    public void setCheckSize(boolean checkSize) {
        this.checkSize = checkSize;
    }

    @Override
    public String getPath() {
        return this.filePath;
    }

    @Override
    public long getSize() {
        if (this.checkSize) {
            return 1000L;
        }
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public CompletableFuture<ByteBuffer> read0(long position, int length) {
        ByteBuffer buffer = this.memStore.duplicate();
        buffer.position((int)position);
        ByteBuffer slice = buffer.slice();
        slice.limit(length);
        return CompletableFuture.completedFuture(slice);
    }

    @Override
    public CompletableFuture<Boolean> commit0(FileSegmentInputStream inputStream, long position, int length, boolean append) {
        try {
            int len;
            if (this.blocker != null && !this.blocker.get().booleanValue()) {
                log.info("Commit Blocker Exception for Memory Test");
                return CompletableFuture.completedFuture(false);
            }
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > 0) {
                this.memStore.put(buffer, 0, len);
            }
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public void destroyFile() {
    }
}

