/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.leader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.leader.LeaderProtoUtils;
import org.apache.ratis.server.storage.FileChunkReader;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.util.JavaUtils;

class InstallSnapshotRequests
implements Iterable<RaftProtos.InstallSnapshotRequestProto> {
    private final RaftServer.Division server;
    private final RaftPeerId followerId;
    private final Function<FileInfo, Path> getRelativePath;
    private final SnapshotInfo snapshot;
    private final String requestId;
    private final int snapshotChunkMaxSize;
    private final long totalSize;
    private final int numFiles;

    InstallSnapshotRequests(RaftServer.Division server, RaftPeerId followerId, String requestId, SnapshotInfo snapshot, int snapshotChunkMaxSize) {
        Function<Path, Path> relativize;
        this.server = server;
        this.followerId = followerId;
        this.requestId = requestId;
        this.snapshot = snapshot;
        this.snapshotChunkMaxSize = snapshotChunkMaxSize;
        List<FileInfo> files = snapshot.getFiles();
        this.totalSize = files.stream().mapToLong(FileInfo::getFileSize).reduce(Long::sum).orElseThrow(() -> new IllegalStateException("Failed to compute total size for snapshot " + snapshot));
        this.numFiles = files.size();
        File snapshotDir = server.getStateMachine().getStateMachineStorage().getSnapshotDir();
        if (snapshotDir != null) {
            Path dir = snapshotDir.toPath();
            relativize = p -> new File("sm", dir.relativize((Path)p).toString()).toPath();
        } else {
            Path dir = server.getRaftStorage().getStorageDir().getRoot().toPath();
            relativize = dir::relativize;
        }
        this.getRelativePath = info -> Optional.of(info.getPath()).filter(Path::isAbsolute).map(relativize).orElseGet(info::getPath);
    }

    @Override
    public Iterator<RaftProtos.InstallSnapshotRequestProto> iterator() {
        return new Iter();
    }

    public String toString() {
        return this.server.getId() + "->" + this.followerId + JavaUtils.getClassSimpleName(this.getClass()) + ": requestId=" + this.requestId + ", snapshot=" + this.snapshot;
    }

    private class Iter
    implements Iterator<RaftProtos.InstallSnapshotRequestProto> {
        private int requestIndex = 0;
        private int fileIndex = 0;
        private FileChunkReader current;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.fileIndex < InstallSnapshotRequests.this.numFiles;
        }

        @Override
        public RaftProtos.InstallSnapshotRequestProto next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("fileIndex = " + this.fileIndex + " >= numFiles = " + InstallSnapshotRequests.this.numFiles);
            }
            FileInfo info = InstallSnapshotRequests.this.snapshot.getFiles().get(this.fileIndex);
            try {
                RaftProtos.FileChunkProto chunk;
                if (this.current == null) {
                    this.current = new FileChunkReader(info, (Path)InstallSnapshotRequests.this.getRelativePath.apply(info));
                }
                if ((chunk = this.current.readFileChunk(InstallSnapshotRequests.this.snapshotChunkMaxSize)).getDone()) {
                    this.current.close();
                    this.current = null;
                    ++this.fileIndex;
                }
                boolean done = this.fileIndex == InstallSnapshotRequests.this.numFiles && chunk.getDone();
                return this.newInstallSnapshotRequest(chunk, done);
            }
            catch (IOException e) {
                if (this.current != null) {
                    try {
                        this.current.close();
                        this.current = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new IllegalStateException("Failed to iterate installSnapshot requests: " + this, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RaftProtos.InstallSnapshotRequestProto newInstallSnapshotRequest(RaftProtos.FileChunkProto chunk, boolean done) {
            RaftServer.Division division = InstallSnapshotRequests.this.server;
            synchronized (division) {
                RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto.Builder b = LeaderProtoUtils.toSnapshotChunkProtoBuilder(InstallSnapshotRequests.this.requestId, this.requestIndex++, InstallSnapshotRequests.this.snapshot.getTermIndex(), chunk, InstallSnapshotRequests.this.totalSize, done);
                return LeaderProtoUtils.toInstallSnapshotRequestProto(InstallSnapshotRequests.this.server, InstallSnapshotRequests.this.followerId, b);
            }
        }
    }
}

