/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.policyengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.policyengine.PerfTestOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineParser {
    static final Logger LOG = LoggerFactory.getLogger(CommandLineParser.class);
    private String servicePoliciesFileName;
    private String[] requestFileNames;
    private String statCollectionFileName;
    private URL servicePoliciesFileURL;
    private URL[] requestFileURLs;
    private URL statCollectionFileURL;
    private int concurrentClientCount = 1;
    private int iterationsCount = 1;
    private boolean isTrieLookupPrefixDisabled = true;
    private boolean isLazyTriePostSetupDisabled = true;
    private String configurationFileName;
    private URL configurationFileURL;
    private Options options = new Options();

    CommandLineParser() {
    }

    final PerfTestOptions parse(String[] args) {
        PerfTestOptions ret = null;
        if (this.parseArguments(args) && this.validateInputFiles()) {
            ret = new PerfTestOptions(this.servicePoliciesFileURL, this.requestFileURLs, this.statCollectionFileURL, this.concurrentClientCount, this.iterationsCount, this.isTrieLookupPrefixDisabled, this.isLazyTriePostSetupDisabled, this.configurationFileURL);
        } else {
            this.showUsage();
        }
        return ret;
    }

    final boolean parseArguments(String[] args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> parseArguments()");
        }
        boolean ret = false;
        this.options.addOption("h", "help", false, "show help.");
        this.options.addOption("s", "service-policies", true, "Policies File Name");
        this.options.addOption("r", "requests", true, "Request Definition File Name");
        this.options.addOption("p", "statistics", true, "Modules for stat collection File Name");
        this.options.addOption("c", "clients", true, "Number of concurrent clients");
        this.options.addOption("n", "cycles", true, "Number of iterations");
        this.options.addOption("f", "configurations", true, "Configuration File Name");
        this.options.addOption("t", "trie-prefilter", false, "Enable trie-prefilter");
        this.options.addOption("d", "trie-lazy-setup", false, "Enable lazy trie-setup");
        DefaultParser commandLineParser = new DefaultParser();
        try {
            CommandLine commandLine = commandLineParser.parse(this.options, args);
            if (commandLine.hasOption("h")) {
                this.showUsage();
                return false;
            }
            this.servicePoliciesFileName = commandLine.getOptionValue("s");
            this.requestFileNames = commandLine.getOptionValues("r");
            this.statCollectionFileName = commandLine.getOptionValue("p");
            this.concurrentClientCount = 1;
            String clientOptionValue = commandLine.getOptionValue("c");
            if (clientOptionValue != null) {
                this.concurrentClientCount = Integer.parseInt(clientOptionValue);
            }
            this.iterationsCount = 1;
            String iterationsOptionValue = commandLine.getOptionValue("n");
            if (iterationsOptionValue != null) {
                this.iterationsCount = Integer.parseInt(iterationsOptionValue);
            }
            if (commandLine.hasOption("t")) {
                this.isTrieLookupPrefixDisabled = false;
            }
            if (commandLine.hasOption("d")) {
                this.isLazyTriePostSetupDisabled = false;
            }
            this.configurationFileName = commandLine.getOptionValue("f");
            if (LOG.isDebugEnabled()) {
                LOG.debug("servicePoliciesFileName=" + this.servicePoliciesFileName + ", requestFileName=" + Arrays.toString(this.requestFileNames));
                LOG.debug("concurrentClientCount=" + this.concurrentClientCount + ", iterationsCount=" + this.iterationsCount);
                LOG.debug("isTrieLookupPrefixDisabled=" + this.isTrieLookupPrefixDisabled);
                LOG.debug("isLazyTriePostSetupDisabled=" + this.isLazyTriePostSetupDisabled);
                LOG.debug("configurationFileName=" + this.configurationFileName);
            }
            ret = true;
        }
        catch (Exception exception) {
            LOG.error("Error processing command-line arguments: ", (Throwable)exception);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== parseArguments() : " + ret);
        }
        return ret;
    }

    final boolean validateInputFiles() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> validateInputFiles()");
        }
        boolean ret = false;
        if (this.servicePoliciesFileName != null) {
            this.servicePoliciesFileURL = CommandLineParser.getInputFileURL(this.servicePoliciesFileName);
            if (this.servicePoliciesFileURL != null) {
                if (this.requestFileNames != null) {
                    if (this.validateRequestFiles()) {
                        ret = true;
                        if (this.statCollectionFileName != null) {
                            this.statCollectionFileURL = CommandLineParser.getInputFileURL(this.statCollectionFileName);
                            boolean bl = ret = this.statCollectionFileURL != null;
                        }
                        if (ret && this.configurationFileName != null) {
                            this.configurationFileURL = CommandLineParser.getInputFileURL(this.configurationFileName);
                            ret = this.configurationFileURL != null;
                        }
                    }
                } else {
                    LOG.error("Error processing requests file: No requests files provided.");
                }
            } else {
                LOG.error("Error processing service-policies file: unreadable service-policies file: " + this.servicePoliciesFileName);
            }
        } else {
            LOG.error("Error processing service-policies file: null service-policies file");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== validateInputFiles(): " + ret);
        }
        return ret;
    }

    final boolean validateRequestFiles() {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> validateRequestFiles()");
        }
        boolean bl = ret = this.requestFileNames.length > 0;
        if (ret) {
            this.requestFileURLs = new URL[this.requestFileNames.length];
            for (int i = 0; ret && i < this.requestFileNames.length; ++i) {
                if (this.requestFileNames[i] != null) {
                    this.requestFileURLs[i] = CommandLineParser.getInputFileURL(this.requestFileNames[i]);
                    if (this.requestFileURLs[i] != null) continue;
                    LOG.error("Cannot read file: " + this.requestFileNames[i]);
                    ret = false;
                    continue;
                }
                LOG.error("Error processing request-file: null input file-name for request-file");
                ret = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== validateRequestFiles(): " + ret);
        }
        return ret;
    }

    public static URL getInputFileURL(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getResourceFileURL(" + name + ")");
        }
        URL ret = null;
        InputStream in = null;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            File f = new File(name);
            if (f.exists() && f.isFile() && f.canRead()) {
                try {
                    in = new FileInputStream(f);
                    ret = f.toURI().toURL();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("URL:" + ret);
                    }
                }
                catch (FileNotFoundException exception) {
                    LOG.error("Error processing input file:" + name + " or no privilege for reading file " + name, (Throwable)exception);
                }
                catch (MalformedURLException malformedException) {
                    LOG.error("Error processing input file:" + name + " cannot be converted to URL " + name, (Throwable)malformedException);
                }
            } else {
                URL fileURL = CommandLineParser.class.getResource(name);
                if (fileURL == null && !name.startsWith("/")) {
                    fileURL = CommandLineParser.class.getResource("/" + name);
                }
                if (fileURL == null && (fileURL = ClassLoader.getSystemClassLoader().getResource(name)) == null && !name.startsWith("/")) {
                    fileURL = ClassLoader.getSystemClassLoader().getResource("/" + name);
                }
                if (fileURL != null) {
                    try {
                        in = fileURL.openStream();
                        ret = fileURL;
                    }
                    catch (Exception exception) {
                        LOG.error(name + " cannot be opened:", (Throwable)exception);
                    }
                } else {
                    LOG.warn("Error processing input file: URL not found for " + name + " or no privilege for reading file " + name);
                }
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getResourceFileURL(" + name + ", URL=" + ret + ")");
        }
        return ret;
    }

    void showUsage() {
        HelpFormatter formater = new HelpFormatter();
        formater.printHelp("perfTester", this.options);
    }
}

