/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.primitives;

import java.io.IOException;
import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferAllocator;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.SymbolTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;

public abstract class AbstractSymbolTypeDecoder
extends AbstractPrimitiveTypeDecoder<Symbol>
implements SymbolTypeDecoder {
    @Override
    public Symbol readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int length = this.readSize(buffer, state);
        if (length == 0) {
            return Symbol.valueOf("");
        }
        if (length > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Symbol encoded size %d is specified to be greater than the amount of data available (%d)", length, buffer.getReadableBytes()));
        }
        try (ProtonBuffer symbolBuffer = buffer.copy(buffer.getReadOffset(), length, true);){
            buffer.advanceReadOffset(length);
            Symbol symbol = Symbol.getSymbol(symbolBuffer, true);
            return symbol;
        }
    }

    public String readString(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return this.readValue(buffer, state).toString();
    }

    @Override
    public Symbol readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        int length = this.readSize(stream, state);
        if (length == 0) {
            return Symbol.valueOf("");
        }
        byte[] symbolBytes = new byte[length];
        try {
            stream.read(symbolBytes);
        }
        catch (IOException ex) {
            throw new DecodeException("Error while reading Symbol payload bytes", ex);
        }
        return Symbol.getSymbol(ProtonBufferAllocator.defaultAllocator().copy(symbolBytes).convertToReadOnly());
    }

    public String readString(InputStream stream, StreamDecoderState state) throws DecodeException {
        return this.readValue(stream, state).toString();
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.advanceReadOffset(this.readSize(buffer, state));
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        try {
            stream.skip(this.readSize(stream, state));
        }
        catch (IOException ex) {
            throw new DecodeException("Error while reading Symbol payload bytes", ex);
        }
    }
}

