/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.type.DateTimes;
import java.time.LocalDate;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeWithTimeZoneToTimestampWithTimeZoneCast {
    private TimeWithTimeZoneToTimestampWithTimeZoneCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static long shortToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision) with time zone") long packedTime) {
        long picos = TimeWithTimeZoneToTimestampWithTimeZoneCast.normalizeAndRound(targetPrecision, DateTimes.rescale(DateTimeEncoding.unpackTimeNanos((long)packedTime), 9, 12), DateTimeEncoding.unpackOffsetMinutes((long)packedTime));
        return DateTimeEncoding.packDateTimeWithZone((long)TimeWithTimeZoneToTimestampWithTimeZoneCast.calculateEpochMillis(session, picos), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)DateTimeEncoding.unpackOffsetMinutes((long)packedTime)));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static long longToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision) with time zone") LongTimeWithTimeZone time) {
        long picos = TimeWithTimeZoneToTimestampWithTimeZoneCast.normalizeAndRound(targetPrecision, time.getPicoseconds(), time.getOffsetMinutes());
        return DateTimeEncoding.packDateTimeWithZone((long)TimeWithTimeZoneToTimestampWithTimeZoneCast.calculateEpochMillis(session, picos), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)time.getOffsetMinutes()));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static LongTimestampWithTimeZone shortToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision) with time zone") long packedTime) {
        long picos = TimeWithTimeZoneToTimestampWithTimeZoneCast.normalizeAndRound(targetPrecision, DateTimes.rescale(DateTimeEncoding.unpackTimeNanos((long)packedTime), 9, 12), DateTimeEncoding.unpackOffsetMinutes((long)packedTime));
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)TimeWithTimeZoneToTimestampWithTimeZoneCast.calculateEpochMillis(session, picos), (int)((int)(picos % 1000000000L)), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)DateTimeEncoding.unpackOffsetMinutes((long)packedTime)));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static LongTimestampWithTimeZone longToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision) with time zone") LongTimeWithTimeZone time) {
        long picos = TimeWithTimeZoneToTimestampWithTimeZoneCast.normalizeAndRound(targetPrecision, time.getPicoseconds(), time.getOffsetMinutes());
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)TimeWithTimeZoneToTimestampWithTimeZoneCast.calculateEpochMillis(session, picos), (int)((int)(picos % 1000000000L)), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)time.getOffsetMinutes()));
    }

    private static long normalizeAndRound(long targetPrecision, long picos, int offsetMinutes) {
        picos -= (long)offsetMinutes * 60000000000000L;
        picos = Math.floorMod(picos, 86400000000000000L);
        picos = DateTimes.round(picos, (int)(12L - targetPrecision));
        return picos;
    }

    private static long calculateEpochMillis(ConnectorSession session, long picos) {
        long epochDay = LocalDate.ofInstant(session.getStart(), session.getTimeZoneKey().getZoneId()).toEpochDay();
        long picosOfDay = picos % 86400000000000000L;
        return Math.multiplyExact(epochDay, 86400000L) + DateTimes.rescale(picosOfDay, 12, 3);
    }
}

