/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.util.List;
import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.lemmatizer.Lemmatizer;
import opennlp.tools.lemmatizer.LemmatizerME;
import opennlp.tools.lemmatizer.LemmatizerModel;
import opennlp.tools.ml.Probabilistic;

@ThreadSafe
public class ThreadSafeLemmatizerME
implements Lemmatizer,
Probabilistic,
AutoCloseable {
    private final LemmatizerModel model;
    private final ThreadLocal<LemmatizerME> threadLocal = new ThreadLocal();

    public ThreadSafeLemmatizerME(LemmatizerModel model) {
        this.model = model;
    }

    private LemmatizerME getLemmatizer() {
        LemmatizerME l = this.threadLocal.get();
        if (l == null) {
            l = new LemmatizerME(this.model);
            this.threadLocal.set(l);
        }
        return l;
    }

    public String[] lemmatize(String[] toks, String[] tags) {
        return this.getLemmatizer().lemmatize(toks, tags);
    }

    public List<List<String>> lemmatize(List<String> toks, List<String> tags) {
        return this.getLemmatizer().lemmatize(toks, tags);
    }

    public double[] probs() {
        return this.getLemmatizer().probs();
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }
}

